/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.amygdalum.testrecorder.DeserializationException;
import net.amygdalum.testrecorder.Deserializer;
import net.amygdalum.testrecorder.SerializedImmutableType;
import net.amygdalum.testrecorder.SerializedReferenceType;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.SerializedValueType;
import net.amygdalum.testrecorder.util.GenericObject;
import net.amygdalum.testrecorder.util.GenericObjectException;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedArray;
import net.amygdalum.testrecorder.values.SerializedField;
import net.amygdalum.testrecorder.values.SerializedImmutable;
import net.amygdalum.testrecorder.values.SerializedList;
import net.amygdalum.testrecorder.values.SerializedLiteral;
import net.amygdalum.testrecorder.values.SerializedMap;
import net.amygdalum.testrecorder.values.SerializedNull;
import net.amygdalum.testrecorder.values.SerializedObject;
import net.amygdalum.testrecorder.values.SerializedSet;

public class SimpleDeserializer
implements Deserializer<Object> {
    private Map<SerializedValue, Object> deserialized = new IdentityHashMap<SerializedValue, Object>();

    private <T> T fetch(SerializedValue key, Supplier<T> supplier, Consumer<T> init) {
        Object value = this.deserialized.get(key);
        if (value == null) {
            value = supplier.get();
            this.deserialized.put(key, value);
            init.accept(value);
        }
        return (T)value;
    }

    @Override
    public Object visitField(SerializedField field) {
        throw new DeserializationException(field.toString());
    }

    @Override
    public Object visitReferenceType(SerializedReferenceType rt) {
        if (rt instanceof SerializedObject) {
            SerializedObject value = (SerializedObject)rt;
            try {
                Object object = this.fetch(value, () -> GenericObject.newInstance(Types.baseType(value.getType())), base -> {
                    for (SerializedField field : value.getFields()) {
                        GenericObject.setField(base, field.getName(), field.getValue().accept(this));
                    }
                });
                return object;
            }
            catch (GenericObjectException e) {
                throw new DeserializationException(value.toString());
            }
        }
        if (rt instanceof SerializedList) {
            SerializedList value = (SerializedList)rt;
            List list = this.fetch(value, ArrayList::new, base -> {
                for (SerializedValue element : value) {
                    base.add(element.accept(this));
                }
            });
            return list;
        }
        if (rt instanceof SerializedMap) {
            SerializedMap value = (SerializedMap)rt;
            Map map = this.fetch(value, LinkedHashMap::new, base -> {
                for (Map.Entry<SerializedValue, SerializedValue> entry : value.entrySet()) {
                    Object k = entry.getKey().accept(this);
                    Object v = entry.getValue().accept(this);
                    base.put(k, v);
                }
            });
            return map;
        }
        if (rt instanceof SerializedSet) {
            SerializedSet value = (SerializedSet)rt;
            Set set = this.fetch(value, LinkedHashSet::new, base -> {
                for (SerializedValue element : value) {
                    base.add(element.accept(this));
                }
            });
            return set;
        }
        if (rt instanceof SerializedArray) {
            SerializedArray value = (SerializedArray)rt;
            Class<?> componentType = value.getRawType();
            SerializedValue[] rawArray = value.getArray();
            Object[] array = this.fetch(value, () -> (Object[])Array.newInstance(componentType, rawArray.length), base -> {
                for (int i = 0; i < rawArray.length; ++i) {
                    base[i] = rawArray[i].accept(this);
                }
            });
            return array;
        }
        if (rt instanceof SerializedNull) {
            return null;
        }
        return null;
    }

    @Override
    public Object visitImmutableType(SerializedImmutableType rt) {
        if (rt instanceof SerializedImmutable) {
            SerializedImmutable value = (SerializedImmutable)rt;
            return this.fetch(value, () -> value.getValue(), this.noInit());
        }
        return null;
    }

    @Override
    public Object visitValueType(SerializedValueType value) {
        return this.fetch(value, () -> ((SerializedLiteral)value).getValue(), this.noInit());
    }

    private <T> Consumer<T> noInit() {
        return base -> {};
    }
}

