/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers;

import java.util.function.Function;
import net.amygdalum.testrecorder.Deserializer;
import net.amygdalum.testrecorder.SerializedImmutableType;
import net.amygdalum.testrecorder.SerializedReferenceType;
import net.amygdalum.testrecorder.SerializedValueType;
import net.amygdalum.testrecorder.values.SerializedField;

public class MappedDeserializer<T, S>
implements Deserializer<T> {
    private Deserializer<S> visitor;
    private Function<S, T> mapping;

    public MappedDeserializer(Deserializer<S> visitor, Function<S, T> mapping) {
        this.visitor = visitor;
        this.mapping = mapping;
    }

    @Override
    public T visitField(SerializedField field) {
        return this.mapping.apply(field.accept(this.visitor));
    }

    @Override
    public T visitReferenceType(SerializedReferenceType value) {
        return this.mapping.apply(value.accept(this.visitor));
    }

    @Override
    public T visitImmutableType(SerializedImmutableType value) {
        return this.mapping.apply(value.accept(this.visitor));
    }

    @Override
    public T visitValueType(SerializedValueType value) {
        return this.mapping.apply(value.accept(this.visitor));
    }
}

