/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import net.amygdalum.testrecorder.ContextSnapshot;
import net.amygdalum.testrecorder.TestGenerator;

public class ScheduledTestGenerator
extends TestGenerator {
    private static volatile Set<ScheduledTestGenerator> dumpOnShutDown;
    private Path path;
    private int counter = 0;
    private int counterInterval;
    private long start = System.currentTimeMillis();
    private long timeInterval;
    private String classNameTemplate;

    public ScheduledTestGenerator(Class<? extends Runnable> initializer) {
        super(initializer);
        this.path = Paths.get(".", new String[0]);
    }

    public ScheduledTestGenerator withDumpTo(Path path) {
        this.path = path;
        return this;
    }

    public ScheduledTestGenerator withClassName(String template) {
        this.classNameTemplate = template;
        return this;
    }

    public ScheduledTestGenerator withDumpOnTimeInterval(long timeInterval) {
        this.timeInterval = timeInterval;
        return this;
    }

    public ScheduledTestGenerator withDumpOnCounterInterval(int counterInterval) {
        this.counterInterval = counterInterval;
        return this;
    }

    public ScheduledTestGenerator withDumpOnShutDown(boolean shutDown) {
        if (shutDown) {
            this.addDumpOnShutdown();
        }
        return this;
    }

    private synchronized void addDumpOnShutdown() {
        if (dumpOnShutDown == null) {
            dumpOnShutDown = new HashSet<ScheduledTestGenerator>();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    for (ScheduledTestGenerator gen : dumpOnShutDown) {
                        gen.dumpResults();
                    }
                }
            }));
        }
        dumpOnShutDown.add(this);
    }

    @Override
    public void accept(ContextSnapshot snapshot) {
        super.accept(snapshot);
        this.checkCounterInterval();
        this.checkTimeInterval();
    }

    private void checkCounterInterval() {
        ++this.counter;
        if (this.counterInterval > 0 && this.counter % this.counterInterval == 0) {
            this.dumpResults();
        }
    }

    private void checkTimeInterval() {
        long oldStart = this.start;
        this.start = System.currentTimeMillis();
        if (this.timeInterval > 0L && this.start - oldStart >= this.timeInterval) {
            this.dumpResults();
        }
    }

    public void dumpResults() {
        this.writeResults(this.path);
        this.clearResults();
    }

    @Override
    public String computeClassName(Class<?> clazz) {
        if (this.classNameTemplate == null) {
            return super.computeClassName(clazz);
        }
        return this.classNameTemplate.replace("${class}", clazz.getSimpleName()).replace("${counter}", String.valueOf(this.counter)).replace("${millis}", String.valueOf(this.start));
    }
}

