/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.SerializationException;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class ByteCode {
    private ByteCode() {
    }

    public static List<LocalVariableNode> range(List<LocalVariableNode> locals, int start, int length) {
        return locals.stream().filter(local -> local.index >= start && local.index < start + length).sorted(Comparator.comparingInt(local -> local.index)).collect(Collectors.toList());
    }

    public static InsnList memorizeLocal(org.objectweb.asm.Type type, int newLocal) {
        InsnList insnList = new InsnList();
        if (type.getSize() == 1) {
            insnList.add((AbstractInsnNode)new InsnNode(89));
            insnList.add(ByteCode.boxPrimitives(type));
            insnList.add((AbstractInsnNode)new VarInsnNode(58, newLocal));
        } else if (type.getSize() == 2) {
            insnList.add((AbstractInsnNode)new InsnNode(92));
            insnList.add(ByteCode.boxPrimitives(type));
            insnList.add((AbstractInsnNode)new VarInsnNode(58, newLocal));
        }
        return insnList;
    }

    public static AbstractInsnNode recallLocal(int newLocal) {
        return new VarInsnNode(25, newLocal);
    }

    public static InsnList pushTypes(org.objectweb.asm.Type ... argumentTypes) {
        int params = argumentTypes.length;
        InsnList insnList = new InsnList();
        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)params));
        insnList.add((AbstractInsnNode)new TypeInsnNode(189, org.objectweb.asm.Type.getInternalName(Type.class)));
        for (int i = 0; i < params; ++i) {
            insnList.add((AbstractInsnNode)new InsnNode(89));
            insnList.add((AbstractInsnNode)new LdcInsnNode((Object)i));
            insnList.add(ByteCode.pushType(argumentTypes[i]));
            insnList.add((AbstractInsnNode)new InsnNode(83));
        }
        return insnList;
    }

    public static InsnList pushAsArray(List<LocalVariableNode> locals, org.objectweb.asm.Type ... argumentTypes) {
        int params = argumentTypes.length;
        InsnList insnList = new InsnList();
        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)params));
        insnList.add((AbstractInsnNode)new TypeInsnNode(189, org.objectweb.asm.Type.getInternalName(Object.class)));
        for (int i = 0; i < params; ++i) {
            insnList.add((AbstractInsnNode)new InsnNode(89));
            insnList.add((AbstractInsnNode)new LdcInsnNode((Object)i));
            LocalVariableNode node = locals.get(i);
            org.objectweb.asm.Type type = org.objectweb.asm.Type.getType((String)node.desc);
            insnList.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(21), node.index));
            insnList.add(ByteCode.boxPrimitives(type));
            insnList.add((AbstractInsnNode)new InsnNode(83));
        }
        return insnList;
    }

    public static AbstractInsnNode pushType(org.objectweb.asm.Type type) {
        if (type.getDescriptor().length() == 1) {
            Class<?> boxedType = ByteCode.getBoxedType(type.getDescriptor().charAt(0));
            return new FieldInsnNode(178, org.objectweb.asm.Type.getInternalName(boxedType), "TYPE", org.objectweb.asm.Type.getDescriptor(Class.class));
        }
        return new LdcInsnNode((Object)type);
    }

    public static InsnList boxPrimitives(org.objectweb.asm.Type type) {
        InsnList insnList = new InsnList();
        if (type.getDescriptor().length() == 1) {
            char desc = type.getDescriptor().charAt(0);
            Class<?> raw = ByteCode.getRawType(desc);
            Class<?> boxed = ByteCode.getBoxedType(desc);
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, org.objectweb.asm.Type.getInternalName(boxed), "valueOf", ByteCode.methodDescriptor(boxed, "valueOf", raw), false));
        }
        return insnList;
    }

    public static InsnList unboxPrimitives(org.objectweb.asm.Type type) {
        InsnList insnList = new InsnList();
        if (type.getDescriptor().length() == 1) {
            char desc = type.getDescriptor().charAt(0);
            Class<?> raw = ByteCode.getRawType(desc);
            Class<?> boxed = ByteCode.getBoxedType(desc);
            insnList.add((AbstractInsnNode)new TypeInsnNode(192, org.objectweb.asm.Type.getInternalName(boxed)));
            String methodName = raw.getSimpleName() + "Value";
            insnList.add((AbstractInsnNode)new MethodInsnNode(182, org.objectweb.asm.Type.getInternalName(boxed), methodName, ByteCode.methodDescriptor(boxed, methodName, new Class[0]), false));
        }
        return insnList;
    }

    public static String constructorDescriptor(Class<?> clazz, Class<?> ... arguments) {
        return org.objectweb.asm.Type.getConstructorDescriptor(ByteCode.constructorOf(clazz, arguments));
    }

    private static <T> Constructor<T> constructorOf(Class<T> clazz, Class<?> ... arguments) {
        try {
            return clazz.getConstructor(arguments);
        }
        catch (NoSuchMethodException e) {
            throw new SerializationException(e);
        }
    }

    public static String methodDescriptor(Class<?> clazz, String name, Class<?> ... arguments) {
        return org.objectweb.asm.Type.getMethodDescriptor((Method)ByteCode.methodOf(clazz, name, arguments));
    }

    private static Method methodOf(Class<?> clazz, String name, Class<?> ... arguments) {
        try {
            return clazz.getMethod(name, arguments);
        }
        catch (NoSuchMethodException e) {
            throw new SerializationException(e);
        }
    }

    public static Class<?> getRawType(char desc) {
        switch (desc) {
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
        }
        return Void.TYPE;
    }

    public static Class<?> getBoxedType(char desc) {
        switch (desc) {
            case 'Z': {
                return Boolean.class;
            }
            case 'C': {
                return Character.class;
            }
            case 'B': {
                return Byte.class;
            }
            case 'S': {
                return Short.class;
            }
            case 'I': {
                return Integer.class;
            }
            case 'F': {
                return Float.class;
            }
            case 'J': {
                return Long.class;
            }
            case 'D': {
                return Double.class;
            }
        }
        return Void.class;
    }
}

