/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.amygdalum.testrecorder.Deserializer;
import net.amygdalum.testrecorder.SerializedValueType;
import net.amygdalum.testrecorder.deserializers.ValuePrinter;
import net.amygdalum.testrecorder.values.AbstractSerializedValue;

public class SerializedLiteral
extends AbstractSerializedValue
implements SerializedValueType {
    public static Set<Class<?>> LITERAL_TYPES = new HashSet<Class>(Arrays.asList(Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Long.TYPE, Double.TYPE, Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Float.class, Long.class, Double.class, String.class));
    private static final Map<Object, SerializedLiteral> KNOWN_LITERALS = new HashMap<Object, SerializedLiteral>();
    private Type resultType;
    private Object value;

    private SerializedLiteral(Type type, Object value) {
        super(value.getClass());
        this.resultType = type;
        this.value = value;
    }

    public static boolean isLiteral(Type type) {
        return LITERAL_TYPES.contains(type);
    }

    public static SerializedLiteral literal(Object value) {
        return SerializedLiteral.literal(value.getClass(), value);
    }

    public static SerializedLiteral literal(Type type, Object value) {
        return KNOWN_LITERALS.computeIfAbsent(value, val -> new SerializedLiteral(type, val));
    }

    @Override
    public Type getResultType() {
        return this.resultType;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public <T> T accept(Deserializer<T> visitor) {
        return visitor.visitValueType(this);
    }

    public String toString() {
        return this.accept(new ValuePrinter());
    }
}

