/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.deserializers.ValuePrinter;

public class SerializedInput {
    private Class<?> clazz;
    private String name;
    private Type resultType;
    private SerializedValue result;
    private Type[] types;
    private SerializedValue[] values;

    public SerializedInput(Class<?> clazz, String name, Type resultType, SerializedValue result, Type[] types, SerializedValue ... values) {
        this.clazz = clazz;
        this.name = name;
        this.resultType = resultType;
        this.result = result;
        this.types = types;
        this.values = values;
    }

    public SerializedInput(Class<?> clazz, String name, Type[] types, SerializedValue ... values) {
        this.clazz = clazz;
        this.name = name;
        this.types = types;
        this.values = values;
    }

    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public Type getResultType() {
        return this.resultType;
    }

    public SerializedValue getResult() {
        return this.result;
    }

    public Type[] getTypes() {
        return this.types;
    }

    public SerializedValue[] getValues() {
        return this.values;
    }

    public String toString() {
        ValuePrinter printer = new ValuePrinter();
        return "<< " + this.clazz.getTypeName() + "." + this.name + "(" + Optional.ofNullable(this.result).map(r -> r.accept(printer)).orElse("void") + ", " + Stream.of(this.values).map(value -> value.accept(printer)).collect(Collectors.joining(", ")) + ")";
    }

    public int hashCode() {
        return this.clazz.hashCode() * 31 + this.name.hashCode() * 19 + this.resultType.hashCode() * 7 + this.result.hashCode() * 3 + Arrays.hashCode(this.types) * 17 + Arrays.hashCode(this.values);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializedInput that = (SerializedInput)obj;
        return this.clazz.equals(that.clazz) && this.name.equals(that.name) && this.resultType.equals(that.resultType) && this.result.equals(that.result) && Arrays.equals(this.types, that.types) && Arrays.equals(this.values, that.values);
    }
}

