/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.util;

import java.util.Arrays;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class PrimitiveArrayMatcher<T>
extends TypeSafeMatcher<T> {
    private T array;

    private PrimitiveArrayMatcher(T array) {
        this.array = array;
    }

    public static Matcher<boolean[]> booleanArrayContaining(boolean ... items) {
        return new PrimitiveArrayMatcher<boolean[]>(items);
    }

    public static Matcher<char[]> charArrayContaining(char ... items) {
        return new PrimitiveArrayMatcher<char[]>(items);
    }

    public static Matcher<byte[]> byteArrayContaining(byte ... items) {
        return new PrimitiveArrayMatcher<byte[]>(items);
    }

    public static Matcher<short[]> shortArrayContaining(short ... items) {
        return new PrimitiveArrayMatcher<short[]>(items);
    }

    public static Matcher<int[]> intArrayContaining(int ... items) {
        return new PrimitiveArrayMatcher<int[]>(items);
    }

    public static Matcher<float[]> floatArrayContaining(float ... items) {
        return new PrimitiveArrayMatcher<float[]>(items);
    }

    public static Matcher<long[]> longArrayContaining(long ... items) {
        return new PrimitiveArrayMatcher<long[]>(items);
    }

    public static Matcher<double[]> doubleArrayContaining(double ... items) {
        return new PrimitiveArrayMatcher<double[]>(items);
    }

    public void describeTo(Description description) {
        description.appendText("an array containing values of type ").appendValue(this.array.getClass().getComponentType()).appendText(": ").appendValue(this.array);
    }

    protected void describeMismatchSafely(T item, Description mismatchDescription) {
        if (!item.getClass().isArray()) {
            mismatchDescription.appendText("not an array");
        } else if (!item.getClass().getComponentType().isPrimitive()) {
            mismatchDescription.appendText("not a primitive array");
        } else if (item.getClass() != this.array.getClass()) {
            mismatchDescription.appendText("of type ").appendValue(item.getClass().getComponentType());
        } else {
            mismatchDescription.appendText("with items ").appendValue(item);
        }
    }

    protected boolean matchesSafely(T item) {
        if (!item.getClass().isArray()) {
            return false;
        }
        if (!item.getClass().getComponentType().isPrimitive()) {
            return false;
        }
        if (item.getClass() != this.array.getClass()) {
            return false;
        }
        Class<?> type = this.array.getClass().getComponentType();
        if (type == Boolean.TYPE) {
            return Arrays.equals((boolean[])this.array, (boolean[])item);
        }
        if (type == Character.TYPE) {
            return Arrays.equals((char[])this.array, (char[])item);
        }
        if (type == Byte.TYPE) {
            return Arrays.equals((byte[])this.array, (byte[])item);
        }
        if (type == Short.TYPE) {
            return Arrays.equals((short[])this.array, (short[])item);
        }
        if (type == Integer.TYPE) {
            return Arrays.equals((int[])this.array, (int[])item);
        }
        if (type == Float.TYPE) {
            return Arrays.equals((float[])this.array, (float[])item);
        }
        if (type == Long.TYPE) {
            return Arrays.equals((long[])this.array, (long[])item);
        }
        if (type == Double.TYPE) {
            return Arrays.equals((double[])this.array, (double[])item);
        }
        return false;
    }
}

