/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class MapMatcher<K, V>
extends TypeSafeMatcher<Map<K, V>> {
    private Map<K, V> entries = new LinkedHashMap();

    public MapMatcher<K, V> entry(K key, V value) {
        this.entries.put(key, value);
        return this;
    }

    public void describeTo(Description description) {
        description.appendValue(this.entries);
    }

    protected boolean matchesSafely(Map<K, V> item) {
        if (item.size() != this.entries.size()) {
            return false;
        }
        for (Map.Entry<K, V> entry : item.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            V expectedValue = this.entries.get(key);
            if (expectedValue == null && value == null) continue;
            if (expectedValue == null && value != null) {
                return false;
            }
            if (expectedValue.equals(value)) continue;
            return false;
        }
        return true;
    }

    public static <K, V> MapMatcher<K, V> noEntries(Class<K> key, Class<V> value) {
        return new MapMatcher<K, V>();
    }

    public static <K, V> MapMatcher<K, V> containsEntries(Class<K> key, Class<V> value) {
        return new MapMatcher<K, V>();
    }
}

