/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.serializers;

import com.almondtools.xrayinterface.XRayInterface;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.SerializerFacade;
import net.amygdalum.testrecorder.SerializerFactory;
import net.amygdalum.testrecorder.TypeSelector;
import net.amygdalum.testrecorder.serializers.HiddenInnerClassSerializer;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedMap;

public class CollectionsMapSerializer
extends HiddenInnerClassSerializer<SerializedMap> {
    public CollectionsMapSerializer(SerializerFacade facade) {
        super(Collections.class, facade);
    }

    @Override
    public List<Class<?>> getMatchingClasses() {
        return this.innerClasses().filter(TypeSelector.startingWith("Unmodifiable", "Synchronized", "Checked", "Empty", "Singleton")).filter(clazz -> Map.class.isAssignableFrom((Class<?>)clazz)).collect(Collectors.toList());
    }

    @Override
    public SerializedMap generate(Type resultType, Type type) {
        return new SerializedMap(type).withResult(resultType);
    }

    @Override
    public void populate(SerializedMap serializedObject, Object object) {
        Type newType;
        ArrayList<Type> keyTypes = new ArrayList<Type>();
        ArrayList<Type> valueTypes = new ArrayList<Type>();
        for (Map.Entry element : ((Map)object).entrySet()) {
            Object key = element.getKey();
            Object value = element.getValue();
            serializedObject.put(this.facade.serialize(key.getClass(), key), this.facade.serialize(value.getClass(), value));
            if (key != null) {
                keyTypes.add(key.getClass());
            }
            if (value == null) continue;
            valueTypes.add(value.getClass());
        }
        if (object.getClass().getSimpleName().contains("Checked")) {
            newType = Types.parameterized(Map.class, null, new Type[]{((CheckedMap)XRayInterface.xray((Object)object).to(CheckedMap.class)).getKeyType(), ((CheckedMap)XRayInterface.xray((Object)object).to(CheckedMap.class)).getValueType()});
            serializedObject.setResultType(newType);
        } else {
            newType = Types.parameterized(Map.class, null, new Type[]{Types.inferType(keyTypes), Types.inferType(valueTypes)});
            serializedObject.setResultType(newType);
        }
    }

    public static class Factory
    implements SerializerFactory<SerializedMap> {
        public CollectionsMapSerializer newSerializer(SerializerFacade facade) {
            return new CollectionsMapSerializer(facade);
        }
    }

    static interface CheckedMap {
        public Class<?> getKeyType();

        public Class<?> getValueType();
    }
}

