/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.matcher;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import net.amygdalum.testrecorder.Deserializer;
import net.amygdalum.testrecorder.SerializedImmutableType;
import net.amygdalum.testrecorder.SerializedReferenceType;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.SerializedValueType;
import net.amygdalum.testrecorder.deserializers.Adaptors;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.DeserializerFactory;
import net.amygdalum.testrecorder.deserializers.LocalVariableNameGenerator;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultArrayAdaptor;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultBigDecimalAdaptor;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultBigIntegerAdaptor;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultListAdaptor;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultLiteralAdaptor;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultMapAdaptor;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultNullAdaptor;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultObjectAdaptor;
import net.amygdalum.testrecorder.deserializers.matcher.DefaultSetAdaptor;
import net.amygdalum.testrecorder.util.GenericMatcher;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedArray;
import net.amygdalum.testrecorder.values.SerializedField;
import net.amygdalum.testrecorder.values.SerializedImmutable;
import net.amygdalum.testrecorder.values.SerializedList;
import net.amygdalum.testrecorder.values.SerializedLiteral;
import net.amygdalum.testrecorder.values.SerializedMap;
import net.amygdalum.testrecorder.values.SerializedNull;
import net.amygdalum.testrecorder.values.SerializedObject;
import net.amygdalum.testrecorder.values.SerializedSet;
import org.hamcrest.Matcher;

public class ObjectToMatcherCode
implements Deserializer<Computation> {
    public static final Adaptors<ObjectToMatcherCode> DEFAULT = new Adaptors<ObjectToMatcherCode>().add(SerializedLiteral.class, new DefaultLiteralAdaptor()).add(SerializedNull.class, new DefaultNullAdaptor()).add(SerializedImmutable.class, new DefaultBigIntegerAdaptor()).add(SerializedImmutable.class, new DefaultBigDecimalAdaptor()).add(SerializedObject.class, new DefaultObjectAdaptor()).add(SerializedArray.class, new DefaultArrayAdaptor()).add(SerializedList.class, new DefaultListAdaptor()).add(SerializedSet.class, new DefaultSetAdaptor()).add(SerializedMap.class, new DefaultMapAdaptor());
    private TypeManager types;
    private Adaptors<ObjectToMatcherCode> adaptors;
    private Set<SerializedValue> computed;

    public ObjectToMatcherCode() {
        this(new LocalVariableNameGenerator(), new TypeManager(), DEFAULT);
    }

    public ObjectToMatcherCode(LocalVariableNameGenerator locals, TypeManager types) {
        this(locals, types, DEFAULT);
    }

    public ObjectToMatcherCode(LocalVariableNameGenerator locals, TypeManager types, Adaptors<ObjectToMatcherCode> adaptors) {
        this.types = types;
        this.adaptors = adaptors;
        this.computed = new HashSet<SerializedValue>();
    }

    public TypeManager getTypes() {
        return this.types;
    }

    public boolean isSimpleValue(SerializedValue element) {
        return element instanceof SerializedNull || element instanceof SerializedLiteral;
    }

    public Computation simpleValue(SerializedValue element) {
        if (element instanceof SerializedNull) {
            return new Computation("null");
        }
        if (element instanceof SerializedLiteral) {
            return new Computation(Templates.asLiteral(((SerializedLiteral)element).getValue()));
        }
        return element.accept(this);
    }

    @Override
    public Computation visitField(SerializedField field) {
        SerializedValue fieldValue = field.getValue();
        if (this.isSimpleValue(fieldValue)) {
            this.types.registerImport(Types.baseType(field.getType()));
            Computation value = this.simpleValue(fieldValue);
            String assignField = Templates.assignLocalVariableStatement(this.types.getRawName(field.getType()), field.getName(), value.getValue());
            return new Computation(assignField, value.getStatements());
        }
        this.types.registerImport(Matcher.class);
        Computation value = fieldValue.accept(this);
        String genericType = this.types.getSimpleName(value.getType());
        String assignField = Templates.assignLocalVariableStatement(genericType, field.getName(), value.getValue());
        return new Computation(assignField, value.getStatements());
    }

    @Override
    public Computation visitReferenceType(SerializedReferenceType value) {
        if (!this.computed.add(value)) {
            this.types.staticImport(GenericMatcher.class, "recursive");
            Type resultType = value.getResultType().equals(value.getType()) ? Types.parameterized(Matcher.class, null, new Type[]{value.getResultType()}) : Types.parameterized(Matcher.class, null, new Type[]{Types.wildcard()});
            return new Computation(Templates.recursiveMatcher(this.types.getRawTypeName(value.getType())), resultType);
        }
        return this.adaptors.tryDeserialize(value, this.types, this);
    }

    @Override
    public Computation visitImmutableType(SerializedImmutableType value) {
        return this.adaptors.tryDeserialize(value, this.types, this);
    }

    @Override
    public Computation visitValueType(SerializedValueType value) {
        return this.adaptors.tryDeserialize(value, this.types, this);
    }

    public static class Factory
    implements DeserializerFactory {
        @Override
        public Deserializer<Computation> create(LocalVariableNameGenerator locals, TypeManager types) {
            return new ObjectToMatcherCode(locals, types);
        }

        @Override
        public Type resultType(Type type) {
            return Types.parameterized(Matcher.class, null, new Type[]{type});
        }
    }
}

