/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.matcher;

import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.DefaultAdaptor;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;
import net.amygdalum.testrecorder.deserializers.matcher.ObjectToMatcherCode;
import net.amygdalum.testrecorder.util.GenericMatcher;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedObject;
import org.hamcrest.Matcher;

public class DefaultObjectAdaptor
extends DefaultAdaptor<SerializedObject, ObjectToMatcherCode>
implements Adaptor<SerializedObject, ObjectToMatcherCode> {
    @Override
    public Computation tryDeserialize(SerializedObject value, ObjectToMatcherCode generator) {
        TypeManager types = generator.getTypes();
        types.registerTypes(new Type[]{value.getResultType(), value.getType(), GenericMatcher.class});
        List fields = value.getFields().stream().sorted().map(field -> field.accept(generator)).collect(Collectors.toList());
        List<String> fieldComputations = fields.stream().flatMap(field -> field.getStatements().stream()).collect(Collectors.toList());
        List<String> fieldAssignments = fields.stream().map(field -> field.getValue()).collect(Collectors.toList());
        Type resultType = Types.parameterized(Matcher.class, null, new Type[]{Types.wrapHidden(value.getResultType())});
        String matcherExpression = this.with(types).createMatcherExpression(value, fieldAssignments);
        return new Computation(matcherExpression, resultType, fieldComputations);
    }

    public TypesAware with(TypeManager types) {
        return new TypesAware(types);
    }

    private static class TypesAware {
        private TypeManager types;

        public TypesAware(TypeManager types) {
            this.types = types;
        }

        public String createMatcherExpression(SerializedObject value, List<String> fieldAssignments) {
            Type type;
            Type resultType = value.getResultType();
            if (Types.baseType(resultType) == Matcher.class) {
                resultType = Types.typeArgument(resultType, 0).orElse(Types.wildcard());
            }
            if (resultType.equals(type = value.getType())) {
                String matcherRawType = this.types.getRawTypeName(type);
                return Templates.genericObjectMatcher(matcherRawType, fieldAssignments);
            }
            String matcherRawType = this.types.getRawTypeName(type);
            String matcherToType = this.types.getRawTypeName(resultType);
            return Templates.genericObjectMatcher(matcherRawType, matcherToType, fieldAssignments);
        }
    }
}

