/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.matcher;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collections;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.DefaultAdaptor;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;
import net.amygdalum.testrecorder.deserializers.matcher.ObjectToMatcherCode;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedImmutable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class DefaultBigDecimalAdaptor
extends DefaultAdaptor<SerializedImmutable<BigDecimal>, ObjectToMatcherCode>
implements Adaptor<SerializedImmutable<BigDecimal>, ObjectToMatcherCode> {
    @Override
    public boolean matches(Type type) {
        return Types.equalTypes(type, BigDecimal.class);
    }

    @Override
    public Computation tryDeserialize(SerializedImmutable<BigDecimal> value, ObjectToMatcherCode generator) {
        TypeManager types = generator.getTypes();
        types.registerImport(BigDecimal.class);
        types.staticImport(Matchers.class, "equalTo");
        String literal = Templates.asLiteral(value.getValue().toPlainString());
        String bigDecimalLiteral = Templates.newObject("BigDecimal", literal);
        String equalToMatcher = Templates.equalToMatcher(bigDecimalLiteral);
        return new Computation(equalToMatcher, Types.parameterized(Matcher.class, null, new Type[]{value.getType()}), Collections.emptyList());
    }
}

