/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.amygdalum.testrecorder.Deserializer;
import net.amygdalum.testrecorder.SerializedImmutableType;
import net.amygdalum.testrecorder.SerializedReferenceType;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.SerializedValueType;
import net.amygdalum.testrecorder.deserializers.Adaptors;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.DeserializerFactory;
import net.amygdalum.testrecorder.deserializers.LocalVariableNameGenerator;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;
import net.amygdalum.testrecorder.deserializers.builder.ArraysListAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.BeanObjectAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.CollectionsListAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.CollectionsMapAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.CollectionsSetAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.DefaultArrayAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.DefaultBigDecimalAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.DefaultBigIntegerAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.DefaultListAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.DefaultLiteralAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.DefaultMapAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.DefaultNullAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.DefaultObjectAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.DefaultSetAdaptor;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedArray;
import net.amygdalum.testrecorder.values.SerializedField;
import net.amygdalum.testrecorder.values.SerializedImmutable;
import net.amygdalum.testrecorder.values.SerializedList;
import net.amygdalum.testrecorder.values.SerializedLiteral;
import net.amygdalum.testrecorder.values.SerializedMap;
import net.amygdalum.testrecorder.values.SerializedNull;
import net.amygdalum.testrecorder.values.SerializedObject;
import net.amygdalum.testrecorder.values.SerializedSet;

public class ObjectToSetupCode
implements Deserializer<Computation> {
    public static final Adaptors<ObjectToSetupCode> DEFAULT = new Adaptors<ObjectToSetupCode>().add(SerializedLiteral.class, new DefaultLiteralAdaptor()).add(SerializedNull.class, new DefaultNullAdaptor()).add(SerializedImmutable.class, new DefaultBigIntegerAdaptor()).add(SerializedImmutable.class, new DefaultBigDecimalAdaptor()).add(SerializedObject.class, new BeanObjectAdaptor()).add(SerializedObject.class, new DefaultObjectAdaptor()).add(SerializedArray.class, new DefaultArrayAdaptor()).add(SerializedList.class, new ArraysListAdaptor()).add(SerializedList.class, new CollectionsListAdaptor()).add(SerializedList.class, new DefaultListAdaptor()).add(SerializedSet.class, new CollectionsSetAdaptor()).add(SerializedSet.class, new DefaultSetAdaptor()).add(SerializedMap.class, new CollectionsMapAdaptor()).add(SerializedMap.class, new DefaultMapAdaptor());
    private TypeManager types;
    private Adaptors<ObjectToSetupCode> adaptors;
    private LocalVariableNameGenerator locals;
    private Map<SerializedValue, String> computed;

    public ObjectToSetupCode() {
        this(new LocalVariableNameGenerator(), new TypeManager(), DEFAULT);
    }

    public ObjectToSetupCode(LocalVariableNameGenerator locals, TypeManager types) {
        this(locals, types, DEFAULT);
    }

    public ObjectToSetupCode(LocalVariableNameGenerator locals, TypeManager types, Adaptors<ObjectToSetupCode> adaptors) {
        this.adaptors = adaptors;
        this.types = types;
        this.locals = locals;
        this.computed = new IdentityHashMap<SerializedValue, String>();
    }

    public TypeManager getTypes() {
        return this.types;
    }

    public String localVariable(SerializedValue value, Type type) {
        String name = this.locals.fetchName(type);
        this.computed.put(value, name);
        return name;
    }

    @Override
    public Computation visitField(SerializedField field) {
        Type type = field.getType();
        Type resultType = Types.wrapHidden(type);
        this.types.registerType(type);
        this.types.registerType(resultType);
        Computation valueTemplate = field.getValue().accept(this);
        List<String> statements = valueTemplate.getStatements();
        String value = valueTemplate.getValue();
        if (Types.isHidden(field.getValue().getResultType()) && !Types.isHidden(type)) {
            String unwrapped = Templates.callMethod(value, "value", new String[0]);
            value = Templates.cast(this.types.getSimpleName(type), unwrapped);
        }
        String assignField = Templates.assignLocalVariableStatement(this.types.getSimpleName(resultType), field.getName(), value);
        return new Computation(assignField, statements);
    }

    @Override
    public Computation visitReferenceType(SerializedReferenceType value) {
        if (this.computed.containsKey(value)) {
            return new Computation(this.computed.get(value), true);
        }
        return this.adaptors.tryDeserialize(value, this.types, this);
    }

    @Override
    public Computation visitValueType(SerializedValueType value) {
        return this.adaptors.tryDeserialize(value, this.types, this);
    }

    @Override
    public Computation visitImmutableType(SerializedImmutableType value) {
        return this.adaptors.tryDeserialize(value, this.types, this);
    }

    public static class Factory
    implements DeserializerFactory {
        public ObjectToSetupCode create(LocalVariableNameGenerator locals, TypeManager types) {
            return new ObjectToSetupCode(locals, types);
        }

        @Override
        public Type resultType(Type type) {
            return type;
        }
    }
}

