/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.DefaultAdaptor;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;
import net.amygdalum.testrecorder.deserializers.builder.ObjectToSetupCode;
import net.amygdalum.testrecorder.values.SerializedSet;

public class DefaultSetAdaptor
extends DefaultAdaptor<SerializedSet, ObjectToSetupCode>
implements Adaptor<SerializedSet, ObjectToSetupCode> {
    @Override
    public Computation tryDeserialize(SerializedSet value, ObjectToSetupCode generator) {
        TypeManager types = generator.getTypes();
        types.registerTypes(value.getResultType(), value.getType());
        List elementTemplates = value.stream().map(element -> element.accept(generator)).collect(Collectors.toList());
        List elements = elementTemplates.stream().map(template -> template.getValue()).collect(Collectors.toList());
        List<String> statements = elementTemplates.stream().flatMap(template -> template.getStatements().stream()).collect(Collectors.toList());
        String name = generator.localVariable(value, (Type)((Object)Set.class));
        String set = Templates.newObject(types.getBestName(value.getType()), new String[0]);
        String setInit = Templates.assignLocalVariableStatement(types.getSimpleName(value.getResultType()), name, set);
        statements.add(setInit);
        for (String element2 : elements) {
            String addElement = Templates.callMethodStatement(name, "add", element2);
            statements.add(addElement);
        }
        return new Computation(name, true, statements);
    }
}

