/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.DefaultAdaptor;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;
import net.amygdalum.testrecorder.deserializers.builder.ObjectToSetupCode;
import net.amygdalum.testrecorder.util.GenericObject;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedObject;

public class DefaultObjectAdaptor
extends DefaultAdaptor<SerializedObject, ObjectToSetupCode>
implements Adaptor<SerializedObject, ObjectToSetupCode> {
    @Override
    public Computation tryDeserialize(SerializedObject value, ObjectToSetupCode generator) {
        TypeManager types = generator.getTypes();
        types.registerTypes(new Type[]{value.getResultType(), GenericObject.class});
        List elementTemplates = value.getFields().stream().sorted().map(element -> element.accept(generator)).collect(Collectors.toList());
        List<String> elements = elementTemplates.stream().map(template -> template.getValue()).collect(Collectors.toList());
        List<String> statements = elementTemplates.stream().flatMap(template -> template.getStatements().stream()).collect(Collectors.toList());
        Type type = value.getType();
        Type resultType = Types.wrapHidden(type);
        String genericObject = Templates.genericObjectConverter(types.getRawTypeName(type), elements);
        String name = generator.localVariable(value, type);
        statements.add(Templates.assignLocalVariableStatement(types.getRawName(resultType), name, genericObject));
        return new Computation(name, statements);
    }
}

