/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.DefaultAdaptor;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;
import net.amygdalum.testrecorder.deserializers.builder.ObjectToSetupCode;
import net.amygdalum.testrecorder.values.SerializedMap;

public class DefaultMapAdaptor
extends DefaultAdaptor<SerializedMap, ObjectToSetupCode>
implements Adaptor<SerializedMap, ObjectToSetupCode> {
    @Override
    public Computation tryDeserialize(SerializedMap value, ObjectToSetupCode generator) {
        TypeManager types = generator.getTypes();
        types.registerTypes(value.getResultType(), value.getType());
        Map<Computation, Computation> elementTemplates = value.entrySet().stream().collect(Collectors.toMap(entry -> ((SerializedValue)entry.getKey()).accept(generator), entry -> ((SerializedValue)entry.getValue()).accept(generator)));
        Map<String, String> elements = elementTemplates.entrySet().stream().collect(Collectors.toMap(entry -> ((Computation)entry.getKey()).getValue(), entry -> ((Computation)entry.getValue()).getValue()));
        List<String> statements = elementTemplates.entrySet().stream().flatMap(entry -> Stream.concat(((Computation)entry.getKey()).getStatements().stream(), ((Computation)entry.getValue()).getStatements().stream())).distinct().collect(Collectors.toList());
        String name = generator.localVariable(value, (Type)((Object)Map.class));
        String map = Templates.newObject(types.getBestName(value.getType()), new String[0]);
        String mapInit = Templates.assignLocalVariableStatement(types.getSimpleName(value.getResultType()), name, map);
        statements.add(mapInit);
        for (Map.Entry<String, String> element : elements.entrySet()) {
            String putEntry = Templates.callMethodStatement(name, "put", element.getKey(), element.getValue());
            statements.add(putEntry);
        }
        return new Computation(name, true, statements);
    }
}

