/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import java.math.BigInteger;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.DefaultAdaptor;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;
import net.amygdalum.testrecorder.deserializers.builder.ObjectToSetupCode;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedImmutable;

public class DefaultBigIntegerAdaptor
extends DefaultAdaptor<SerializedImmutable<BigInteger>, ObjectToSetupCode>
implements Adaptor<SerializedImmutable<BigInteger>, ObjectToSetupCode> {
    @Override
    public boolean matches(Type type) {
        return Types.equalTypes(type, BigInteger.class);
    }

    @Override
    public Computation tryDeserialize(SerializedImmutable<BigInteger> value, ObjectToSetupCode generator) {
        TypeManager types = generator.getTypes();
        types.registerImport(BigInteger.class);
        String literal = Templates.asLiteral(value.getValue().toString());
        String bigInteger = Templates.newObject("BigInteger", literal);
        return new Computation(bigInteger);
    }
}

