/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.DefaultAdaptor;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;
import net.amygdalum.testrecorder.deserializers.builder.ObjectToSetupCode;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedImmutable;

public class DefaultBigDecimalAdaptor
extends DefaultAdaptor<SerializedImmutable<BigDecimal>, ObjectToSetupCode>
implements Adaptor<SerializedImmutable<BigDecimal>, ObjectToSetupCode> {
    @Override
    public boolean matches(Type type) {
        return Types.equalTypes(type, BigDecimal.class);
    }

    @Override
    public Computation tryDeserialize(SerializedImmutable<BigDecimal> value, ObjectToSetupCode generator) {
        TypeManager types = generator.getTypes();
        types.registerImport(BigDecimal.class);
        String literal = Templates.asLiteral(value.getValue().toPlainString());
        String bigDecimal = Templates.newObject("BigDecimal", literal);
        return new Computation(bigDecimal);
    }
}

