/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import net.amygdalum.testrecorder.DeserializationException;
import net.amygdalum.testrecorder.TypeSelector;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;
import net.amygdalum.testrecorder.deserializers.builder.DefaultSetAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.ObjectToSetupCode;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedSet;

public class CollectionsSetAdaptor
implements Adaptor<SerializedSet, ObjectToSetupCode> {
    private DefaultSetAdaptor adaptor = new DefaultSetAdaptor();

    @Override
    public Class<? extends Adaptor<SerializedSet, ObjectToSetupCode>> parent() {
        return DefaultSetAdaptor.class;
    }

    @Override
    public boolean matches(Type type) {
        return TypeSelector.innerClasses(Collections.class).filter(TypeSelector.startingWith("Unmodifiable", "Synchronized", "Checked", "Empty", "Singleton")).filter(element -> Set.class.isAssignableFrom((Class<?>)element)).anyMatch(element -> Types.equalTypes(element, type));
    }

    @Override
    public Computation tryDeserialize(SerializedSet value, ObjectToSetupCode generator) {
        TypeManager types = generator.getTypes();
        types.registerImport(Set.class);
        String name = types.getSimpleName(value.getType());
        if (name.contains("Empty")) {
            return this.tryDeserializeEmpty(value, generator);
        }
        if (name.contains("Singleton")) {
            return this.tryDeserializeSingleton(value, generator);
        }
        if (name.contains("Unmodifiable")) {
            return this.tryDeserializeUnmodifiable(value, generator);
        }
        if (name.contains("Synchronized")) {
            return this.tryDeserializeSynchronized(value, generator);
        }
        if (name.contains("Checked")) {
            return this.tryDeserializeChecked(value, generator);
        }
        throw new DeserializationException(value.toString());
    }

    private Computation createOrdinarySet(SerializedSet value, ObjectToSetupCode generator) {
        SerializedSet baseValue = new SerializedSet(Types.parameterized(LinkedHashSet.class, null, new Type[]{value.getComponentType()}));
        baseValue.addAll(value);
        return this.adaptor.tryDeserialize(baseValue, generator);
    }

    private Computation tryDeserializeEmpty(SerializedSet value, ObjectToSetupCode generator) {
        String factoryMethod = "emptySet";
        TypeManager types = generator.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        Type resultType = Types.parameterized(Set.class, null, new Type[]{value.getComponentType()});
        String resultSet = generator.localVariable(value, resultType);
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getBestName(resultType), resultSet, Templates.callLocalMethod(factoryMethod, new String[0]));
        return new Computation(resultSet, Arrays.asList(decoratingStatement));
    }

    private Computation tryDeserializeSingleton(SerializedSet value, ObjectToSetupCode generator) {
        String factoryMethod = "singleton";
        TypeManager types = generator.getTypes();
        types.registerImport(Set.class);
        types.staticImport(Collections.class, factoryMethod);
        Computation computation = value.iterator().next().accept(generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        Type resultType = Types.parameterized(Set.class, null, new Type[]{value.getComponentType()});
        String resultList = generator.localVariable(value, resultType);
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getBestName(resultType), resultList, Templates.callLocalMethod(factoryMethod, resultBase));
        statements.add(decoratingStatement);
        return new Computation(resultList, statements);
    }

    private Computation tryDeserializeUnmodifiable(SerializedSet value, ObjectToSetupCode generator) {
        String factoryMethod = "unmodifiableSet";
        TypeManager types = generator.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        Computation computation = this.createOrdinarySet(value, generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        Type resultType = Types.parameterized(Set.class, null, new Type[]{value.getComponentType()});
        String resultList = generator.localVariable(value, resultType);
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getBestName(resultType), resultList, Templates.callLocalMethod(factoryMethod, resultBase));
        statements.add(decoratingStatement);
        return new Computation(resultList, statements);
    }

    private Computation tryDeserializeSynchronized(SerializedSet value, ObjectToSetupCode generator) {
        String factoryMethod = "synchronizedSet";
        TypeManager types = generator.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        Computation computation = this.createOrdinarySet(value, generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        Type resultType = Types.parameterized(Set.class, null, new Type[]{value.getComponentType()});
        String resultList = generator.localVariable(value, resultType);
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getBestName(resultType), resultList, Templates.callLocalMethod(factoryMethod, resultBase));
        statements.add(decoratingStatement);
        return new Computation(resultList, statements);
    }

    private Computation tryDeserializeChecked(SerializedSet value, ObjectToSetupCode generator) {
        String factoryMethod = "checkedSet";
        TypeManager types = generator.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        Computation computation = this.createOrdinarySet(value, generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        String checkedType = types.getRawTypeName(value.getComponentType());
        Type resultType = Types.parameterized(Set.class, null, new Type[]{value.getComponentType()});
        String resultList = generator.localVariable(value, resultType);
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getBestName(resultType), resultList, Templates.callLocalMethod(factoryMethod, resultBase, checkedType));
        statements.add(decoratingStatement);
        return new Computation(resultList, statements);
    }
}

