/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.amygdalum.testrecorder.DeserializationException;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.TypeSelector;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;
import net.amygdalum.testrecorder.deserializers.builder.DefaultMapAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.ObjectToSetupCode;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedMap;

public class CollectionsMapAdaptor
implements Adaptor<SerializedMap, ObjectToSetupCode> {
    private DefaultMapAdaptor adaptor = new DefaultMapAdaptor();

    @Override
    public Class<? extends Adaptor<SerializedMap, ObjectToSetupCode>> parent() {
        return DefaultMapAdaptor.class;
    }

    @Override
    public boolean matches(Type type) {
        return TypeSelector.innerClasses(Collections.class).filter(TypeSelector.startingWith("Unmodifiable", "Synchronized", "Checked", "Empty", "Singleton")).filter(element -> Map.class.isAssignableFrom((Class<?>)element)).anyMatch(element -> Types.equalTypes(element, type));
    }

    @Override
    public Computation tryDeserialize(SerializedMap value, ObjectToSetupCode generator) {
        TypeManager types = generator.getTypes();
        types.registerImport(Map.class);
        String name = types.getSimpleName(value.getType());
        if (name.contains("Empty")) {
            return this.tryDeserializeEmpty(value, generator);
        }
        if (name.contains("Singleton")) {
            return this.tryDeserializeSingleton(value, generator);
        }
        if (name.contains("Unmodifiable")) {
            return this.tryDeserializeUnmodifiable(value, generator);
        }
        if (name.contains("Synchronized")) {
            return this.tryDeserializeSynchronized(value, generator);
        }
        if (name.contains("Checked")) {
            return this.tryDeserializeChecked(value, generator);
        }
        throw new DeserializationException(value.toString());
    }

    private Computation createOrdinaryMap(SerializedMap value, ObjectToSetupCode generator) {
        SerializedMap baseValue = new SerializedMap(Types.parameterized(LinkedHashMap.class, null, new Type[]{value.getMapKeyType(), value.getMapValueType()}));
        baseValue.putAll(value);
        return this.adaptor.tryDeserialize(baseValue, generator);
    }

    private Computation tryDeserializeEmpty(SerializedMap value, ObjectToSetupCode generator) {
        String factoryMethod = "emptyMap";
        TypeManager types = generator.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        Type resultType = Types.parameterized(Map.class, null, new Type[]{value.getMapKeyType(), value.getMapValueType()});
        String resultMap = generator.localVariable(value, resultType);
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getBestName(resultType), resultMap, Templates.callLocalMethod(factoryMethod, new String[0]));
        return new Computation(resultMap, Arrays.asList(decoratingStatement));
    }

    private Computation tryDeserializeSingleton(SerializedMap value, ObjectToSetupCode generator) {
        String factoryMethod = "singletonMap";
        TypeManager types = generator.getTypes();
        types.registerImport(Map.class);
        types.staticImport(Collections.class, factoryMethod);
        Map.Entry<SerializedValue, SerializedValue> entry = value.entrySet().iterator().next();
        LinkedList<String> statements = new LinkedList<String>();
        Computation keyComputation = entry.getKey().accept(generator);
        statements.addAll(keyComputation.getStatements());
        String resultKey = keyComputation.getValue();
        Computation valueComputation = entry.getValue().accept(generator);
        statements.addAll(valueComputation.getStatements());
        String resultValue = valueComputation.getValue();
        Type resultType = Types.parameterized(Map.class, null, new Type[]{value.getMapKeyType(), value.getMapValueType()});
        String resultList = generator.localVariable(value, resultType);
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getBestName(resultType), resultList, Templates.callLocalMethod(factoryMethod, resultKey, resultValue));
        statements.add(decoratingStatement);
        return new Computation(resultList, statements);
    }

    private Computation tryDeserializeUnmodifiable(SerializedMap value, ObjectToSetupCode generator) {
        String factoryMethod = "unmodifiableMap";
        TypeManager types = generator.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        Computation computation = this.createOrdinaryMap(value, generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        Type resultType = Types.parameterized(Map.class, null, new Type[]{value.getMapKeyType(), value.getMapValueType()});
        String resultList = generator.localVariable(value, resultType);
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getBestName(resultType), resultList, Templates.callLocalMethod(factoryMethod, resultBase));
        statements.add(decoratingStatement);
        return new Computation(resultList, statements);
    }

    private Computation tryDeserializeSynchronized(SerializedMap value, ObjectToSetupCode generator) {
        String factoryMethod = "synchronizedMap";
        TypeManager types = generator.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        Computation computation = this.createOrdinaryMap(value, generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        Type resultType = Types.parameterized(Map.class, null, new Type[]{value.getMapKeyType(), value.getMapValueType()});
        String resultList = generator.localVariable(value, resultType);
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getBestName(resultType), resultList, Templates.callLocalMethod(factoryMethod, resultBase));
        statements.add(decoratingStatement);
        return new Computation(resultList, statements);
    }

    private Computation tryDeserializeChecked(SerializedMap value, ObjectToSetupCode generator) {
        String factoryMethod = "checkedMap";
        TypeManager types = generator.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        Computation computation = this.createOrdinaryMap(value, generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        String checkedKeyType = types.getRawTypeName(value.getMapKeyType());
        String checkedValueType = types.getRawTypeName(value.getMapValueType());
        Type resultType = Types.parameterized(Map.class, null, new Type[]{value.getMapKeyType(), value.getMapValueType()});
        String resultList = generator.localVariable(value, resultType);
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getBestName(resultType), resultList, Templates.callLocalMethod(factoryMethod, resultBase, checkedKeyType, checkedValueType));
        statements.add(decoratingStatement);
        return new Computation(resultList, statements);
    }
}

