/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.Wrapped;
import net.amygdalum.testrecorder.util.Types;

public class TypeManager {
    private Map<String, String> imports = new LinkedHashMap<String, String>();
    private Set<String> staticImports = new LinkedHashSet<String>();
    private Set<Type> noImports = new LinkedHashSet<Type>();

    public List<String> getImports() {
        return Stream.concat(this.imports.values().stream(), this.staticImports.stream()).collect(Collectors.toList());
    }

    public void staticImport(Class<?> type, String method) {
        this.staticImports.add("static " + type.getName() + "." + method);
    }

    public void registerTypes(Type ... types) {
        for (Type type : types) {
            this.registerType(type);
        }
    }

    public void registerType(Type type) {
        if (type instanceof Class) {
            this.registerImport((Class)type);
        } else if (type instanceof GenericArrayType) {
            this.registerType(((GenericArrayType)type).getGenericComponentType());
        } else if (type instanceof ParameterizedType) {
            this.registerType(((ParameterizedType)type).getRawType());
            this.registerTypes(((ParameterizedType)type).getActualTypeArguments());
        }
    }

    public void registerImport(Class<?> clazz) {
        if (this.noImports.contains(clazz)) {
            return;
        }
        if (Types.isHidden(clazz)) {
            this.registerImport(Wrapped.class);
            this.staticImport(Wrapped.class, "clazz");
            this.noImports.add(clazz);
        } else if (this.imports.containsKey(clazz.getSimpleName())) {
            if (!this.imports.get(clazz.getSimpleName()).equals(this.getFullName(clazz))) {
                this.noImports.add(clazz);
            }
        } else {
            if (clazz.isPrimitive()) {
                return;
            }
            if (clazz.isArray()) {
                this.registerImport(clazz.getComponentType());
            } else {
                this.imports.put(clazz.getSimpleName(), this.getFullName(clazz));
            }
        }
    }

    public String getFullName(Class<?> clazz) {
        return clazz.getName().replace('$', '.');
    }

    public String getBestName(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            String base = this.getSimpleName(clazz);
            String generics = clazz.getTypeParameters().length > 0 ? "<>" : "";
            return base + generics;
        }
        if (type instanceof GenericArrayType) {
            return this.getSimpleName(((GenericArrayType)type).getGenericComponentType()) + "[]";
        }
        if (type instanceof ParameterizedType) {
            return this.getSimpleName(((ParameterizedType)type).getRawType()) + Stream.of(((ParameterizedType)type).getActualTypeArguments()).map(argtype -> this.getSimpleName((Type)argtype)).collect(Collectors.joining(", ", "<", ">"));
        }
        throw new UnsupportedOperationException();
    }

    public String getSimpleName(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (this.noImports.contains(clazz)) {
                return clazz.getName().replace('$', '.');
            }
            return clazz.getSimpleName();
        }
        if (type instanceof GenericArrayType) {
            return this.getSimpleName(((GenericArrayType)type).getGenericComponentType()) + "[]";
        }
        if (type instanceof ParameterizedType) {
            return this.getSimpleName(((ParameterizedType)type).getRawType()) + Stream.of(((ParameterizedType)type).getActualTypeArguments()).map(argtype -> this.getSimpleName((Type)argtype)).collect(Collectors.joining(", ", "<", ">"));
        }
        if (type instanceof WildcardType) {
            return "?";
        }
        throw new UnsupportedOperationException();
    }

    public String getRawName(Type type) {
        if (type instanceof Class) {
            return this.getSimpleName(type);
        }
        if (type instanceof GenericArrayType) {
            return this.getRawName(((GenericArrayType)type).getGenericComponentType()) + "[]";
        }
        if (type instanceof ParameterizedType) {
            return this.getRawName(((ParameterizedType)type).getRawType());
        }
        throw new UnsupportedOperationException();
    }

    public String getRawTypeName(Type type) {
        if (Types.isHidden(type)) {
            return this.getWrappedName(type);
        }
        return this.getRawName(type) + ".class";
    }

    public String getWrappedName(Type type) {
        return "clazz(\"" + Types.baseType(type).getName() + "\")";
    }
}

