/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.Deserializer;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.ConstructorParams;
import net.amygdalum.testrecorder.deserializers.SetterParam;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;

public class ConstructionPlan {
    private String name;
    private ConstructorParams constructorParams;
    private List<SetterParam> setterParams;

    public ConstructionPlan(String name, ConstructorParams constructorParams, List<SetterParam> setterParams) {
        this.name = name;
        this.constructorParams = constructorParams;
        this.setterParams = setterParams;
    }

    public Object execute() {
        try {
            Object base = this.constructorParams.apply();
            for (SetterParam param : this.setterParams) {
                param.apply(base);
            }
            return base;
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    public Computation compute(TypeManager types, Deserializer<Computation> compiler) {
        Class<?> clazz = this.constructorParams.getType();
        ArrayList<String> statements = new ArrayList<String>();
        List computedParams = this.constructorParams.getValues().stream().map(value -> (Computation)value.accept(compiler)).collect(Collectors.toList());
        statements.addAll(computedParams.stream().flatMap(computation -> computation.getStatements().stream()).collect(Collectors.toList()));
        String[] params = (String[])computedParams.stream().map(computation -> computation.getValue()).toArray(String[]::new);
        String bean = Templates.newObject(types.getBestName(clazz), params);
        String constructorStatement = Templates.assignLocalVariableStatement(types.getSimpleName(clazz), this.name, bean);
        statements.add(constructorStatement);
        for (SetterParam param : this.setterParams) {
            Computation fieldComputation = param.computeValue().accept(compiler);
            statements.addAll(fieldComputation.getStatements());
            String setStatement = Templates.callMethodStatement(this.name, param.getName(), fieldComputation.getValue());
            statements.add(setStatement);
        }
        return new Computation(this.name, true, statements);
    }
}

