/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.data;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import net.amygdalum.testrecorder.data.TestDataGenerator;
import net.amygdalum.testrecorder.data.TestValueGenerator;
import net.amygdalum.testrecorder.util.Reflections;

public class GenericObjectGenerator<T>
implements TestValueGenerator<T> {
    private Class<T> clazz;

    public GenericObjectGenerator(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public T create(TestDataGenerator generator) {
        T instance = this.makeInstance(generator);
        for (Class<T> current = this.clazz; current != Object.class; current = current.getSuperclass()) {
            this.generateFields(generator, instance, current);
        }
        return instance;
    }

    private T makeInstance(TestDataGenerator generator) {
        try {
            return this.clazz.newInstance();
        }
        catch (ReflectiveOperationException | RuntimeException exception) {
            for (Constructor<?> constructor : this.clazz.getDeclaredConstructors()) {
                try {
                    return (T)Reflections.accessing(constructor).call(() -> {
                        Object[] args = this.createArgs(generator, constructor.getParameterTypes());
                        return constructor.newInstance(args);
                    });
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                }
            }
            return null;
        }
    }

    private Object[] createArgs(TestDataGenerator generator, Class<?>[] parameterTypes) {
        Object[] args = new Object[parameterTypes.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = generator.create(parameterTypes[i]);
        }
        return args;
    }

    private void generateFields(TestDataGenerator generator, T instance, Class<?> current) {
        for (Field field : current.getDeclaredFields()) {
            if (field.isSynthetic()) continue;
            try {
                Reflections.accessing(field).exec(() -> field.set(instance, generator.create(field.getType())));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
    }
}

