/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder;

import java.lang.instrument.Instrumentation;
import net.amygdalum.testrecorder.DefaultConfig;
import net.amygdalum.testrecorder.SnapshotConfig;
import net.amygdalum.testrecorder.SnapshotInstrumentor;

public class TestRecorderAgent {
    public static void premain(String agentArgs, Instrumentation inst) {
        SnapshotConfig config = TestRecorderAgent.loadConfig(agentArgs);
        inst.addTransformer(new SnapshotInstrumentor(config));
        TestRecorderAgent.initialize(config.getInitializer());
    }

    public static void initialize(Class<? extends Runnable> initializerClass) {
        if (initializerClass != null) {
            try {
                Runnable initializer = initializerClass.newInstance();
                initializer.run();
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                System.out.println("initializer failed with " + e.getMessage() + ", skipping");
            }
        }
    }

    private static SnapshotConfig loadConfig(String agentArgs) {
        try {
            Class<?> config = Class.forName(agentArgs);
            System.out.println("loading config " + config.getSimpleName());
            return (SnapshotConfig)config.newInstance();
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            System.out.println("loading default config");
            return new DefaultConfig();
        }
    }
}

