/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.ConfigurableSerializerFacade;
import net.amygdalum.testrecorder.Deserializer;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.SerializerFacade;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.DeserializerFactory;
import net.amygdalum.testrecorder.deserializers.LocalVariableNameGenerator;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;
import net.amygdalum.testrecorder.deserializers.builder.ObjectToSetupCode;
import net.amygdalum.testrecorder.profile.DefaultSerializationProfile;

public class CodeSerializer {
    private SerializerFacade facade;
    private TypeManager types = new TypeManager();
    private DeserializerFactory serializers;

    public CodeSerializer() {
        this(new ConfigurableSerializerFacade(new DefaultSerializationProfile()), new ObjectToSetupCode.Factory());
    }

    public CodeSerializer(DeserializerFactory serializers) {
        this(new ConfigurableSerializerFacade(new DefaultSerializationProfile()), serializers);
    }

    public CodeSerializer(SerializerFacade facade, DeserializerFactory serializers) {
        this.facade = facade;
        this.serializers = serializers;
    }

    public String serialize(Object value) {
        return this.serialize(this.serializers.resultType(value.getClass()), value);
    }

    public String serialize(Type type, Object value) {
        SerializedValue serializedValue = this.facade.serialize(type, value);
        return new Generator(serializedValue).generateCode();
    }

    private class Generator {
        private LocalVariableNameGenerator locals;
        private SerializedValue value;
        private String type;
        private List<String> statements;

        public Generator(SerializedValue value) {
            this.value = value;
            this.type = CodeSerializer.this.types.getSimpleName(value.getResultType());
            this.locals = new LocalVariableNameGenerator();
            this.statements = new ArrayList<String>();
        }

        public String generateCode() {
            Deserializer<Computation> serializer = CodeSerializer.this.serializers.create(this.locals, CodeSerializer.this.types);
            Computation serialized = this.value.accept(serializer);
            this.statements.addAll(serialized.getStatements());
            if (!serialized.isStored()) {
                String name = this.locals.fetchName(this.value.getClass());
                this.statements.add(Templates.assignLocalVariableStatement(this.type, name, serialized.getValue()));
            }
            return this.statements.stream().collect(Collectors.joining("\n"));
        }
    }
}

