/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.visitors;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.Wrapped;

public class TypeManager {
    private Map<String, String> imports = new LinkedHashMap<String, String>();
    private Set<String> staticImports = new LinkedHashSet<String>();
    private Set<Type> noImports = new LinkedHashSet<Type>();

    public List<String> getImports() {
        return Stream.concat(this.imports.values().stream(), this.staticImports.stream()).collect(Collectors.toList());
    }

    public void staticImport(Class<?> type, String method) {
        this.staticImports.add("static " + type.getName() + "." + method);
    }

    public void registerTypes(Type ... types) {
        for (Type type : types) {
            this.registerType(type);
        }
    }

    public void registerType(Type type) {
        if (type instanceof Class) {
            this.registerImport((Class)type);
        } else if (type instanceof GenericArrayType) {
            this.registerType(((GenericArrayType)type).getGenericComponentType());
        } else if (type instanceof ParameterizedType) {
            this.registerType(((ParameterizedType)type).getRawType());
            this.registerTypes(((ParameterizedType)type).getActualTypeArguments());
        }
    }

    public void registerImport(Class<?> clazz) {
        if (this.noImports.contains(clazz)) {
            return;
        }
        if (TypeManager.isHidden(clazz)) {
            this.registerImport(Wrapped.class);
            this.staticImport(Wrapped.class, "clazz");
            this.noImports.add(clazz);
        } else if (this.imports.containsKey(clazz.getSimpleName())) {
            if (!this.imports.get(clazz.getSimpleName()).equals(this.getFullName(clazz))) {
                this.noImports.add(clazz);
            }
        } else {
            if (clazz.isPrimitive()) {
                return;
            }
            if (clazz.isArray()) {
                this.registerImport(clazz.getComponentType());
            } else {
                this.imports.put(clazz.getSimpleName(), this.getFullName(clazz));
            }
        }
    }

    public String getFullName(Class<?> clazz) {
        return clazz.getName().replace('$', '.');
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    public static Field getDeclaredField(Class<?> clazz, String name) {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException | SecurityException e) {
            return null;
        }
    }

    public static Class<?> getBase(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(TypeManager.getBase(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        if (type instanceof ParameterizedType) {
            return TypeManager.getBase(((ParameterizedType)type).getRawType());
        }
        return Object.class;
    }

    public static Type getArgument(Type type, int i) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[i];
        }
        return TypeManager.wildcard();
    }

    public String getBestName(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            String base = this.getSimpleName(clazz);
            String generics = clazz.getTypeParameters().length > 0 ? "<>" : "";
            return base + generics;
        }
        if (type instanceof GenericArrayType) {
            return this.getSimpleName(((GenericArrayType)type).getGenericComponentType()) + "[]";
        }
        if (type instanceof ParameterizedType) {
            return this.getSimpleName(((ParameterizedType)type).getRawType()) + Stream.of(((ParameterizedType)type).getActualTypeArguments()).map(argtype -> this.getSimpleName((Type)argtype)).collect(Collectors.joining(", ", "<", ">"));
        }
        throw new UnsupportedOperationException();
    }

    public String getSimpleName(Type type) {
        if (TypeManager.isHidden(type)) {
            return Wrapped.class.getSimpleName();
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (this.noImports.contains(clazz)) {
                return clazz.getName().replace('$', '.');
            }
            return clazz.getSimpleName();
        }
        if (type instanceof GenericArrayType) {
            return this.getSimpleName(((GenericArrayType)type).getGenericComponentType()) + "[]";
        }
        if (type instanceof ParameterizedType) {
            return this.getSimpleName(((ParameterizedType)type).getRawType()) + Stream.of(((ParameterizedType)type).getActualTypeArguments()).map(argtype -> this.getSimpleName((Type)argtype)).collect(Collectors.joining(", ", "<", ">"));
        }
        if (type instanceof WildcardType) {
            return "?";
        }
        throw new UnsupportedOperationException();
    }

    public String getRawName(Type type) {
        if (type instanceof Class) {
            return this.getSimpleName(type);
        }
        if (type instanceof GenericArrayType) {
            return this.getRawName(((GenericArrayType)type).getGenericComponentType()) + "[]";
        }
        if (type instanceof ParameterizedType) {
            return this.getRawName(((ParameterizedType)type).getRawType());
        }
        throw new UnsupportedOperationException();
    }

    public String getRawTypeName(Type type) {
        if (TypeManager.isHidden(type)) {
            return this.getWrappedName(type);
        }
        return this.getRawName((Class)type) + ".class";
    }

    public static boolean isPrimitive(Type type) {
        return type instanceof Class && ((Class)type).isPrimitive();
    }

    public String getWrappedName(Type type) {
        return "clazz(\"" + TypeManager.getBase(type).getName() + "\")";
    }

    public static boolean isHidden(Type type) {
        return !Modifier.isPublic(TypeManager.getBase(type).getModifiers());
    }

    public static Type parameterized(final Type raw, final Type owner, final Type ... typeArgs) {
        return new ParameterizedType(){

            @Override
            public Type getRawType() {
                return raw;
            }

            @Override
            public Type getOwnerType() {
                return owner;
            }

            @Override
            public Type[] getActualTypeArguments() {
                return typeArgs;
            }
        };
    }

    public static Type wildcard() {
        return new WildcardType(){

            @Override
            public Type[] getUpperBounds() {
                return new Type[0];
            }

            @Override
            public Type[] getLowerBounds() {
                return new Type[0];
            }
        };
    }
}

