/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.visitors;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.SerializedCollectionVisitor;
import net.amygdalum.testrecorder.SerializedImmutableVisitor;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.SerializedValueVisitor;
import net.amygdalum.testrecorder.util.GenericObject;
import net.amygdalum.testrecorder.values.SerializedArray;
import net.amygdalum.testrecorder.values.SerializedBigDecimal;
import net.amygdalum.testrecorder.values.SerializedBigInteger;
import net.amygdalum.testrecorder.values.SerializedField;
import net.amygdalum.testrecorder.values.SerializedList;
import net.amygdalum.testrecorder.values.SerializedLiteral;
import net.amygdalum.testrecorder.values.SerializedMap;
import net.amygdalum.testrecorder.values.SerializedNull;
import net.amygdalum.testrecorder.values.SerializedObject;
import net.amygdalum.testrecorder.values.SerializedSet;
import net.amygdalum.testrecorder.visitors.Computation;
import net.amygdalum.testrecorder.visitors.Construction;
import net.amygdalum.testrecorder.visitors.LocalVariableNameGenerator;
import net.amygdalum.testrecorder.visitors.SerializedValueVisitorFactory;
import net.amygdalum.testrecorder.visitors.Templates;
import net.amygdalum.testrecorder.visitors.TypeManager;

public class ObjectToSetupCode
implements SerializedValueVisitor<Computation>,
SerializedCollectionVisitor<Computation>,
SerializedImmutableVisitor<Computation> {
    private LocalVariableNameGenerator locals;
    private Map<SerializedValue, String> computed;
    private TypeManager types;

    public ObjectToSetupCode() {
        this(new LocalVariableNameGenerator(), new TypeManager());
    }

    public ObjectToSetupCode(LocalVariableNameGenerator locals, TypeManager types) {
        this.locals = locals;
        this.types = types;
        this.computed = new IdentityHashMap<SerializedValue, String>();
    }

    public LocalVariableNameGenerator getLocals() {
        return this.locals;
    }

    public TypeManager getTypes() {
        return this.types;
    }

    private String localVariable(SerializedValue value, Type type) {
        String name = this.locals.fetchName(type);
        this.computed.put(value, name);
        return name;
    }

    @Override
    public Computation visitField(SerializedField field) {
        this.types.registerType(field.getType());
        Computation valueTemplate = field.getValue().accept(this);
        List<String> statements = valueTemplate.getStatements();
        if (TypeManager.isHidden(field.getValue().getValueType()) && !TypeManager.isHidden(field.getType())) {
            String unwrapped = Templates.callMethod(valueTemplate.getValue(), "value", new String[0]);
            String casted = Templates.cast(this.types.getSimpleName(field.getType()), unwrapped);
            String assignField = Templates.assignLocalVariableStatement(this.types.getSimpleName(field.getType()), field.getName(), casted);
            return new Computation(assignField, statements);
        }
        String assignField = Templates.assignLocalVariableStatement(this.types.getSimpleName(field.getType()), field.getName(), valueTemplate.getValue());
        return new Computation(assignField, statements);
    }

    @Override
    public Computation visitObject(SerializedObject value) {
        if (this.computed.containsKey(value)) {
            return new Computation(this.computed.get(value), true);
        }
        try {
            return this.renderBeanSetup(value);
        }
        catch (BeanSetupFailedException e) {
            return this.renderGenericSetup(value);
        }
    }

    private Computation renderBeanSetup(SerializedObject value) throws BeanSetupFailedException {
        try {
            String name = this.localVariable(value, value.getValueType());
            return new Construction(name, value).computeBest(this.types, this);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new BeanSetupFailedException();
        }
    }

    private Computation renderGenericSetup(SerializedObject value) {
        this.types.registerTypes(new Type[]{value.getType(), GenericObject.class});
        List elementTemplates = value.getFields().stream().sorted().map(element -> element.accept(this)).collect(Collectors.toList());
        List<String> elements = elementTemplates.stream().map(template -> template.getValue()).collect(Collectors.toList());
        List<String> statements = elementTemplates.stream().flatMap(template -> template.getStatements().stream()).collect(Collectors.toList());
        String genericObject = Templates.genericObjectConverter(this.types.getRawTypeName(value.getValueType()), elements);
        String name = this.localVariable(value, value.getValueType());
        statements.add(Templates.assignLocalVariableStatement(this.types.getRawName(value.getValueType()), name, genericObject));
        return new Computation(name, statements);
    }

    @Override
    public Computation visitList(SerializedList value) {
        if (this.computed.containsKey(value)) {
            return new Computation(this.computed.get(value), true);
        }
        return this.renderListSetup(value);
    }

    private Computation renderListSetup(SerializedList value) {
        this.types.registerTypes(value.getType(), value.getValueType());
        List elementTemplates = value.stream().map(element -> element.accept(this)).collect(Collectors.toList());
        List elements = elementTemplates.stream().map(template -> template.getValue()).collect(Collectors.toList());
        List<String> statements = elementTemplates.stream().flatMap(template -> template.getStatements().stream()).collect(Collectors.toList());
        String name = this.localVariable(value, (Type)((Object)List.class));
        String list = Templates.newObject(this.types.getBestName(value.getValueType()), new String[0]);
        String listInit = Templates.assignLocalVariableStatement(this.types.getSimpleName(value.getType()), name, list);
        statements.add(listInit);
        for (String element2 : elements) {
            String addElement = Templates.callMethodStatement(name, "add", element2);
            statements.add(addElement);
        }
        return new Computation(name, true, statements);
    }

    @Override
    public Computation visitSet(SerializedSet value) {
        if (this.computed.containsKey(value)) {
            return new Computation(this.computed.get(value), true);
        }
        return this.renderSetSetup(value);
    }

    private Computation renderSetSetup(SerializedSet value) {
        this.types.registerTypes(value.getType(), value.getValueType());
        List elementTemplates = value.stream().map(element -> element.accept(this)).collect(Collectors.toList());
        List elements = elementTemplates.stream().map(template -> template.getValue()).collect(Collectors.toList());
        List<String> statements = elementTemplates.stream().flatMap(template -> template.getStatements().stream()).collect(Collectors.toList());
        String name = this.localVariable(value, (Type)((Object)Set.class));
        String set = Templates.newObject(this.types.getBestName(value.getValueType()), new String[0]);
        String setInit = Templates.assignLocalVariableStatement(this.types.getSimpleName(value.getType()), name, set);
        statements.add(setInit);
        for (String element2 : elements) {
            String addElement = Templates.callMethodStatement(name, "add", element2);
            statements.add(addElement);
        }
        return new Computation(name, true, statements);
    }

    @Override
    public Computation visitMap(SerializedMap value) {
        if (this.computed.containsKey(value)) {
            return new Computation(this.computed.get(value), true);
        }
        return this.renderMapSetup(value);
    }

    private Computation renderMapSetup(SerializedMap value) {
        this.types.registerTypes(value.getType(), value.getValueType());
        Map<Computation, Computation> elementTemplates = value.entrySet().stream().collect(Collectors.toMap(entry -> ((SerializedValue)entry.getKey()).accept(this), entry -> ((SerializedValue)entry.getValue()).accept(this)));
        Map<String, String> elements = elementTemplates.entrySet().stream().collect(Collectors.toMap(entry -> ((Computation)entry.getKey()).getValue(), entry -> ((Computation)entry.getValue()).getValue()));
        List<String> statements = elementTemplates.entrySet().stream().flatMap(entry -> Stream.concat(((Computation)entry.getKey()).getStatements().stream(), ((Computation)entry.getValue()).getStatements().stream())).distinct().collect(Collectors.toList());
        String name = this.localVariable(value, (Type)((Object)Map.class));
        String map = Templates.newObject(this.types.getBestName(value.getValueType()), new String[0]);
        String mapInit = Templates.assignLocalVariableStatement(this.types.getSimpleName(value.getType()), name, map);
        statements.add(mapInit);
        for (Map.Entry<String, String> element : elements.entrySet()) {
            String putEntry = Templates.callMethodStatement(name, "put", element.getKey(), element.getValue());
            statements.add(putEntry);
        }
        return new Computation(name, true, statements);
    }

    @Override
    public Computation visitArray(SerializedArray value) {
        if (this.computed.containsKey(value)) {
            return new Computation(this.computed.get(value), true);
        }
        return this.renderArraySetup(value);
    }

    private Computation renderArraySetup(SerializedArray value) {
        this.types.registerType(value.getType());
        List elementTemplates = Stream.of(value.getArray()).map(element -> element.accept(this)).collect(Collectors.toList());
        List<String> elements = elementTemplates.stream().map(template -> template.getValue()).collect(Collectors.toList());
        List<String> statements = elementTemplates.stream().flatMap(template -> template.getStatements().stream()).collect(Collectors.toList());
        String arrayLiteral = Templates.arrayLiteral(this.types.getSimpleName(value.getType()), elements);
        String name = this.localVariable(value, value.getType());
        statements.add(Templates.assignLocalVariableStatement(this.types.getSimpleName(value.getType()), name, arrayLiteral));
        return new Computation(name, statements);
    }

    @Override
    public Computation visitLiteral(SerializedLiteral value) {
        Object literalValue = value.getValue();
        String literal = Templates.asLiteral(literalValue);
        return new Computation(literal);
    }

    @Override
    public Computation visitBigDecimal(SerializedBigDecimal value) {
        this.types.registerImport(BigDecimal.class);
        String literal = Templates.asLiteral(((BigDecimal)value.getValue()).toPlainString());
        String bigDecimal = Templates.newObject("BigDecimal", literal);
        return new Computation(bigDecimal);
    }

    @Override
    public Computation visitBigInteger(SerializedBigInteger value) {
        this.types.registerImport(BigInteger.class);
        String literal = Templates.asLiteral(((BigInteger)value.getValue()).toString());
        String bigInteger = Templates.newObject("BigInteger", literal);
        return new Computation(bigInteger);
    }

    @Override
    public Computation visitNull(SerializedNull value) {
        return new Computation("null");
    }

    @Override
    public Computation visitUnknown(SerializedValue value) {
        return Computation.NULL;
    }

    private static class BeanSetupFailedException
    extends Exception {
    }

    public static class Factory
    implements SerializedValueVisitorFactory {
        public ObjectToSetupCode create(LocalVariableNameGenerator locals, TypeManager types) {
            return new ObjectToSetupCode(locals, types);
        }

        @Override
        public Type resultType(Type type) {
            return type;
        }
    }
}

