/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.visitors;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.util.GenericObject;
import net.amygdalum.testrecorder.values.SerializedField;
import net.amygdalum.testrecorder.values.SerializedLiteral;
import net.amygdalum.testrecorder.values.SerializedNull;
import net.amygdalum.testrecorder.visitors.ConstructorParam;

public class ConstructorParams {
    private Constructor<?> constructor;
    private SerializedField[] fields;
    private Object[] values;

    public ConstructorParams(Constructor<?> constructor) {
        this.constructor = constructor;
        this.fields = new SerializedField[constructor.getParameterCount()];
        this.values = ConstructorParams.createDefaultArgumetns(constructor);
    }

    private static Object[] createDefaultArgumetns(Constructor<?> constructor) {
        Object[] objects = new Object[constructor.getParameterCount()];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = GenericObject.getDefaultValue(constructor.getParameterTypes()[i]);
        }
        return objects;
    }

    public void add(ConstructorParam param) {
        int index = param.getParamNumber();
        this.fields[index] = param.getField();
        this.values[index] = param.getValue();
    }

    public Object apply() throws ReflectiveOperationException {
        return this.constructor.newInstance(this.values);
    }

    public Class<?> getType() {
        return this.constructor.getDeclaringClass();
    }

    public SerializedField[] getFields() {
        return this.fields;
    }

    public List<SerializedValue> getValues() {
        ArrayList<SerializedValue> serializedValues = new ArrayList<SerializedValue>(this.fields.length);
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i] == null) {
                Class<?> parameterType = this.constructor.getParameterTypes()[i];
                if (parameterType == String.class) {
                    serializedValues.add(SerializedNull.nullInstance(String.class));
                    continue;
                }
                if (SerializedLiteral.isLiteral(parameterType)) {
                    serializedValues.add(SerializedLiteral.literal(parameterType, this.values[i]));
                    continue;
                }
                serializedValues.add(SerializedNull.nullInstance(parameterType));
                continue;
            }
            serializedValues.add(this.fields[i].getValue());
        }
        return serializedValues;
    }
}

