/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.visitors;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.amygdalum.testrecorder.SerializedValueVisitor;
import net.amygdalum.testrecorder.util.GenericComparison;
import net.amygdalum.testrecorder.util.GenericObject;
import net.amygdalum.testrecorder.values.SerializedField;
import net.amygdalum.testrecorder.values.SerializedObject;
import net.amygdalum.testrecorder.visitors.Computation;
import net.amygdalum.testrecorder.visitors.ConstructionPlan;
import net.amygdalum.testrecorder.visitors.ConstructorParam;
import net.amygdalum.testrecorder.visitors.ConstructorParams;
import net.amygdalum.testrecorder.visitors.Deserializer;
import net.amygdalum.testrecorder.visitors.SetterParam;
import net.amygdalum.testrecorder.visitors.TypeManager;

public class Construction {
    private Deserializer deserializer = new Deserializer();
    private SerializedObject serialized;
    private String name;
    private Object value;
    private Map<Constructor<?>, List<ConstructorParam>> constructors;
    private List<SetterParam> setters;

    public Construction(String name, SerializedObject value) {
        this.name = name;
        this.serialized = value;
        this.value = this.serialized.accept(this.deserializer);
        this.constructors = new HashMap();
        this.setters = new ArrayList<SetterParam>();
    }

    public Computation computeBest(TypeManager types, SerializedValueVisitor<Computation> compiler) throws InstantiationException {
        this.fillOrigins();
        return this.computeConstructionPlans().stream().filter(plan -> GenericComparison.equals(plan.execute(), this.value)).sorted().findFirst().map(plan -> plan.compute(types, compiler)).orElseThrow(() -> new InstantiationException());
    }

    private List<ConstructionPlan> computeConstructionPlans() {
        ArrayList<ConstructionPlan> constructionsPlans = new ArrayList<ConstructionPlan>();
        for (Constructor<?> constructor : this.constructors.keySet()) {
            constructionsPlans.add(this.computeConstructionPlan(constructor));
        }
        return constructionsPlans;
    }

    private ConstructionPlan computeConstructionPlan(Constructor<?> constructor) {
        HashSet<SerializedField> todo = new HashSet<SerializedField>(this.serialized.getFields());
        List<ConstructorParam> setByConstructor = this.constructors.get(constructor);
        for (ConstructorParam constructorParam : setByConstructor) {
            todo.remove(constructorParam.getField());
        }
        ArrayList<SetterParam> setBySetter = new ArrayList<SetterParam>();
        for (SetterParam param : this.setters) {
            SerializedField field = param.getField();
            if (!todo.contains(field)) continue;
            todo.remove(field);
            setBySetter.add(param);
        }
        ConstructorParams constructorParams = this.constructorOf(constructor, setByConstructor);
        return new ConstructionPlan(this.name, constructorParams, setBySetter);
    }

    private ConstructorParams constructorOf(Constructor<?> constructor, List<ConstructorParam> params) {
        ConstructorParams constructorParams = new ConstructorParams(constructor);
        for (ConstructorParam param : params) {
            constructorParams.add(param);
        }
        return constructorParams;
    }

    private void fillOrigins() {
        ArrayList<Object> bases = new ArrayList<Object>();
        bases.add(this.buildFromStandardConstructor());
        bases.addAll(this.buildFromConstructors());
        bases.removeIf(Objects::isNull);
        this.applySetters(bases);
    }

    private Object buildFromStandardConstructor() {
        try {
            Constructor<?> constructor = this.serialized.getValueType().getConstructor(new Class[0]);
            this.constructors.put(constructor, new ArrayList());
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    private List<Object> buildFromConstructors() {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (SerializedField field : this.serialized.getFields()) {
            String fieldName = field.getName();
            Object fieldValue = field.getValue().accept(this.deserializer);
            for (Constructor<?> constructor : this.serialized.getValueType().getConstructors()) {
                List params = this.constructors.computeIfAbsent(constructor, key -> new ArrayList());
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> parameterType = parameterTypes[i];
                    if (!this.matches(parameterType, fieldValue)) continue;
                    Object uniqueFieldValue = this.isDefault(parameterType, fieldValue) ? GenericObject.getNonDefaultValue(parameterType) : fieldValue;
                    Object[] arguments = this.createArguments(uniqueFieldValue, parameterTypes, i);
                    try {
                        Object result = constructor.newInstance(arguments);
                        if (!this.isSet(result, fieldName, uniqueFieldValue)) continue;
                        params.add(new ConstructorParam(constructor, i, field, fieldValue));
                        continue;
                    }
                    catch (ReflectiveOperationException e) {
                        // empty catch block
                    }
                }
                Object[] arguments = this.createArguments(params, parameterTypes);
                try {
                    Object result = constructor.newInstance(arguments);
                    objects.add(result);
                }
                catch (ReflectiveOperationException e) {
                    // empty catch block
                }
            }
        }
        return objects;
    }

    private void applySetters(List<Object> bases) {
        for (SerializedField field : this.serialized.getFields()) {
            String fieldName = field.getName();
            Object fieldValue = field.getValue().accept(this.deserializer);
            block3: for (Method method : this.serialized.getValueType().getMethods()) {
                Class<?>[] parameterTypes;
                if (!method.getName().startsWith("set") || (parameterTypes = method.getParameterTypes()).length != 1 || !this.matches(parameterTypes[0], fieldValue)) continue;
                for (Object base : bases) {
                    try {
                        if (this.isSet(base, fieldName, fieldValue)) continue block3;
                        method.invoke(base, fieldValue);
                        if (this.isSet(base, fieldName, fieldValue)) continue;
                    }
                    catch (ReflectiveOperationException e) {}
                    continue block3;
                }
                this.setters.add(new SetterParam(method, field, fieldValue));
            }
        }
    }

    private boolean matches(Class<?> type, Object value) {
        return this.isDefault(type, value) || type.isInstance(value);
    }

    private boolean isDefault(Class<?> type, Object value) {
        return !type.isPrimitive() && value == null || type.isPrimitive() && value != null && GenericObject.getDefaultValue(type).getClass() == value.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSet(Object base, String fieldName, Object expectedValue) throws IllegalAccessException {
        Class<?> clazz = base.getClass();
        while (clazz != Object.class) {
            try {
                Field f = clazz.getDeclaredField(fieldName);
                boolean accessible = f.isAccessible();
                try {
                    Object foundValue;
                    if (!accessible) {
                        f.setAccessible(true);
                    }
                    if ((foundValue = f.get(base)) == expectedValue) {
                        boolean bl = true;
                        return bl;
                    }
                    if (foundValue == null || expectedValue == null) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = foundValue.equals(expectedValue);
                    return bl;
                }
                finally {
                    if (!accessible) {
                        f.setAccessible(true);
                    }
                }
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return false;
    }

    private Object[] createArguments(Object fieldValue, Class<?>[] parameterTypes, int index) {
        Object[] arguments = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            arguments[i] = i == index ? fieldValue : GenericObject.getDefaultValue(parameterTypes[i]);
        }
        return arguments;
    }

    private Object[] createArguments(List<ConstructorParam> params, Class<?>[] parameterTypes) {
        Object[] arguments = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            int paramNumber = i;
            arguments[i] = params.stream().filter(param -> param.getParamNumber() == paramNumber).map(param -> param.getValue()).filter(Objects::nonNull).findFirst().orElseGet(() -> GenericObject.getDefaultValue(parameterTypes[paramNumber]));
        }
        return arguments;
    }
}

