/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.lang.reflect.Type;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.visitors.SerializedValuePrinter;

public class SerializedOutput {
    private Class<?> clazz;
    private String name;
    private Type[] types;
    private SerializedValue[] values;

    public SerializedOutput(Class<?> clazz, String name, Type[] types, SerializedValue ... values) {
        this.clazz = clazz;
        this.name = name;
        this.types = types;
        this.values = values;
    }

    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public Type[] getTypes() {
        return this.types;
    }

    public SerializedValue[] getValues() {
        return this.values;
    }

    public String toString() {
        SerializedValuePrinter printer = new SerializedValuePrinter();
        return ">> " + this.clazz.getTypeName() + "." + this.name + Stream.of(this.values).map(value -> value.accept(printer)).collect(Collectors.joining(", ", "(", ")"));
    }

    public int hashCode() {
        return this.clazz.hashCode() * 37 + this.name.hashCode() * 29 + this.types.hashCode() * 11 + this.values.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializedOutput that = (SerializedOutput)obj;
        return this.clazz.equals(that.clazz) && this.name.equals(that.name) && this.types.equals(that.types) && this.values.equals(that.values);
    }
}

