/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.SerializedValueVisitor;
import net.amygdalum.testrecorder.visitors.SerializedValuePrinter;

public class SerializedLiteral
implements SerializedValue {
    public static Set<Class<?>> LITERAL_TYPES = new HashSet<Class>(Arrays.asList(Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Long.TYPE, Double.TYPE, Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Float.class, Long.class, Double.class, String.class));
    private static final Map<Object, SerializedLiteral> KNOWN_LITERALS = new HashMap<Object, SerializedLiteral>();
    private Type type;
    private Object value;

    private SerializedLiteral(Type type, Object value) {
        this.type = type;
        this.value = value;
    }

    public static boolean isLiteral(Type type) {
        return LITERAL_TYPES.contains(type);
    }

    public static SerializedLiteral literal(Type type, Object value) {
        return KNOWN_LITERALS.computeIfAbsent(value, val -> new SerializedLiteral(type, val));
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Class<?> getValueType() {
        return this.value.getClass();
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public <T> T accept(SerializedValueVisitor<T> visitor) {
        return visitor.visitLiteral(this);
    }

    public String toString() {
        return this.accept(new SerializedValuePrinter());
    }
}

