/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import net.amygdalum.testrecorder.SerializedCollectionVisitor;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.SerializedValueVisitor;
import net.amygdalum.testrecorder.values.GenericTypeResolver;
import net.amygdalum.testrecorder.visitors.SerializedValuePrinter;

public class SerializedList
implements SerializedValue,
List<SerializedValue> {
    private Type type;
    private Class<?> valueType;
    private List<SerializedValue> list;

    public SerializedList(Type type, Class<?> valueType) {
        this.type = type;
        this.valueType = valueType;
        this.list = new ArrayList<SerializedValue>();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Class<?> getValueType() {
        return this.valueType;
    }

    public void setValueType(Class<?> valueType) {
        this.valueType = valueType;
    }

    public Type getComponentType() {
        Set<Type> allTypes = GenericTypeResolver.findAllTypes(this.type);
        return (Type)((Object)allTypes.stream().filter(type -> type instanceof ParameterizedType).map(type -> (ParameterizedType)type).filter(type -> type.getRawType().equals(List.class)).map(type -> GenericTypeResolver.resolve(allTypes, type.getActualTypeArguments()[0])).findFirst().orElse((Type)((Object)Object.class)));
    }

    @Override
    public <T> T accept(SerializedValueVisitor<T> visitor) {
        return (T)visitor.as(SerializedCollectionVisitor.extend(visitor)).map(v -> v.visitList(this)).orElseGet(() -> visitor.visitUnknown(this));
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<SerializedValue> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(SerializedValue e) {
        return this.list.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends SerializedValue> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends SerializedValue> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public SerializedValue get(int index) {
        return this.list.get(index);
    }

    @Override
    public SerializedValue set(int index, SerializedValue element) {
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, SerializedValue element) {
        this.list.add(index, element);
    }

    @Override
    public SerializedValue remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<SerializedValue> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<SerializedValue> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<SerializedValue> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    public String toString() {
        return this.accept(new SerializedValuePrinter());
    }
}

