/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.SerializedValueVisitor;
import net.amygdalum.testrecorder.visitors.SerializedValuePrinter;

public class SerializedArray
implements SerializedValue {
    private Type type;
    private Class<?> valueType;
    private List<SerializedValue> array;

    public SerializedArray(Type type, Class<?> valueType) {
        this.type = type;
        this.valueType = valueType;
        this.array = new ArrayList<SerializedValue>();
    }

    public SerializedArray with(SerializedValue ... values) {
        this.array.addAll(Arrays.asList(values));
        return this;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Class<?> getValueType() {
        return this.valueType;
    }

    public Type getComponentType() {
        if (this.type instanceof Class && ((Class)this.type).isArray()) {
            return ((Class)this.type).getComponentType();
        }
        if (this.type instanceof GenericArrayType) {
            return ((GenericArrayType)this.type).getGenericComponentType();
        }
        return Object.class;
    }

    public Class<?> getRawType() {
        if (this.type instanceof Class && ((Class)this.type).isArray()) {
            return ((Class)this.type).getComponentType();
        }
        return Object.class;
    }

    public SerializedValue[] getArray() {
        return this.array.toArray(new SerializedValue[0]);
    }

    public List<SerializedValue> getArrayAsList() {
        return this.array;
    }

    @Override
    public <T> T accept(SerializedValueVisitor<T> visitor) {
        return visitor.visitArray(this);
    }

    public void add(SerializedValue value) {
        this.array.add(value);
    }

    public String toString() {
        return this.accept(new SerializedValuePrinter());
    }
}

