/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public final class GenericTypeResolver {
    private GenericTypeResolver() {
    }

    public static Type resolve(Set<Type> allTypes, Type type) {
        while (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            Object decl = typeVariable.getGenericDeclaration();
            if (!(decl instanceof Class)) {
                return Object.class;
            }
            Class clazz = (Class)decl;
            int pos = Arrays.asList(clazz.getTypeParameters()).indexOf(typeVariable);
            type = (Type)((Object)allTypes.stream().filter(cand -> cand instanceof ParameterizedType).map(cand -> (ParameterizedType)cand).filter(cand -> cand.getRawType() == decl).findFirst().map(cand -> cand.getActualTypeArguments()[pos]).orElse((Type)((Object)Object.class)));
        }
        return type;
    }

    public static Set<Type> findAllTypes(Type type) {
        return GenericTypeResolver.findAllTypes(type, new LinkedHashSet<Type>());
    }

    public static Set<Type> findAllTypes(Type type, Set<Type> all) {
        if (type == null) {
            return all;
        }
        boolean changed = all.add(type);
        if (!changed) {
            return all;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return GenericTypeResolver.findAllTypes(parameterizedType.getRawType(), all);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            for (Type boundType : typeVariable.getBounds()) {
                GenericTypeResolver.findAllTypes(boundType, all);
            }
            return all;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            if (wildcardType.getUpperBounds() != null) {
                for (Type boundType : wildcardType.getUpperBounds()) {
                    GenericTypeResolver.findAllTypes(boundType, all);
                }
            }
            return all;
        }
        if (type instanceof GenericArrayType) {
            return GenericTypeResolver.findAllTypes(Array.class, all);
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            for (Type interfaceType : clazz.getGenericInterfaces()) {
                GenericTypeResolver.findAllTypes(interfaceType, all);
            }
            return GenericTypeResolver.findAllTypes(clazz.getGenericSuperclass(), all);
        }
        return all;
    }
}

