/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.util;

import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.Queue;
import net.amygdalum.testrecorder.values.SerializedLiteral;

public class GenericComparison {
    private Object left;
    private Object right;

    public GenericComparison(Object left, Object right) {
        this.left = left;
        this.right = right;
    }

    public Object getLeft() {
        return this.left;
    }

    public Object getRight() {
        return this.right;
    }

    public static boolean equals(Object o1, Object o2) {
        return GenericComparison.equals(new GenericComparison(o1, o2));
    }

    public static boolean equals(GenericComparison p) {
        LinkedList<GenericComparison> todo = new LinkedList<GenericComparison>();
        todo.add(p);
        return GenericComparison.equals(todo);
    }

    public static boolean equals(Queue<GenericComparison> todo) {
        while (!todo.isEmpty()) {
            GenericComparison current = todo.remove();
            if (current.eval(todo)) continue;
            return false;
        }
        return true;
    }

    public boolean eval(Queue<GenericComparison> todo) {
        if (this.left.getClass() != this.right.getClass()) {
            return false;
        }
        Class<?> clazz = this.left.getClass();
        if (SerializedLiteral.isLiteral(clazz)) {
            return this.left.equals(this.right);
        }
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                if (field.isSynthetic() || GenericComparison.equals(this.left, field, this.right, field, todo)) continue;
                return false;
            }
            clazz = clazz.getSuperclass();
        }
        return true;
    }

    public static boolean equals(Object left, Field lfield, Object right, Field rfield, Queue<GenericComparison> todo) {
        try {
            Object f1 = GenericComparison.getValue(lfield, left);
            Object f2 = GenericComparison.getValue(rfield, right);
            if (f1 == f2) {
                return true;
            }
            if (f1 == null) {
                return false;
            }
            if (f2 == null) {
                return false;
            }
            if (f1.equals(f2)) {
                return true;
            }
            todo.add(new GenericComparison(f1, f2));
            return true;
        }
        catch (ReflectiveOperationException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getValue(Field field, Object item) throws ReflectiveOperationException {
        boolean access = field.isAccessible();
        if (!access) {
            field.setAccessible(true);
        }
        try {
            Object object = field.get(item);
            return object;
        }
        finally {
            if (!access) {
                field.setAccessible(false);
            }
        }
    }
}

