/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.util;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.util.OutputListener;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class ExpectedOutput
implements OutputListener {
    private Queue<OutputExpectation> expected = new LinkedList<OutputExpectation>();

    public ExpectedOutput expect(Class<?> clazz, String method, Matcher<?> ... args) {
        this.expected.add(new OutputExpectation(clazz, method, args));
        return this;
    }

    @Override
    public void notifyOutput(Class<?> clazz, String method, Object ... args) {
        OutputExpectation expectedOutput = this.expected.remove();
        expectedOutput.verify(clazz, method, args);
    }

    public void verify() {
        if (!this.expected.isEmpty()) {
            StringBuilder message = new StringBuilder("expected (but not found) output :\n");
            for (OutputExpectation outputExpectation : this.expected) {
                message.append(outputExpectation.expected()).append(",\n");
            }
            throw new AssertionError((Object)message.toString());
        }
    }

    private static class OutputExpectation {
        private Class<?> clazz;
        private String method;
        private Matcher<?>[] args;

        public OutputExpectation(Class<?> clazz, String method, Matcher<?>[] args) {
            this.clazz = clazz;
            this.method = method;
            this.args = args;
        }

        public void verify(Class<?> clazz, String method, Object ... args) {
            if (!this.clazz.equals(clazz)) {
                throw new AssertionError((Object)("expected output " + this.expected() + ", but found " + this.found(clazz, method, args)));
            }
            if (!this.method.equals(method)) {
                throw new AssertionError((Object)("expected output " + this.expected() + ", but found " + this.found(clazz, method, args)));
            }
            for (int i = 0; i < args.length; ++i) {
                if (!this.args[i].matches(args[i])) {
                    throw new AssertionError((Object)("expected output " + this.expected() + ", but found " + this.found(clazz, method, args)));
                }
            }
        }

        public String expected() {
            StringDescription description = new StringDescription();
            description.appendText(this.clazz.getSimpleName() + "." + this.method);
            description.appendList("(", ", ", ")", Arrays.asList(this.args));
            return description.toString();
        }

        public String found(Class<?> clazz, String method, Object ... args) {
            return clazz.getSimpleName() + "." + method + Stream.of(args).map(arg -> arg.toString()).collect(Collectors.joining(", ", "(", ")"));
        }
    }
}

