/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.serializers;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import net.amygdalum.testrecorder.Serializer;
import net.amygdalum.testrecorder.SerializerFacade;
import net.amygdalum.testrecorder.SnapshotExcluded;
import net.amygdalum.testrecorder.values.SerializedObject;

public class GenericSerializer
implements Serializer<SerializedObject> {
    private SerializerFacade facade;

    public GenericSerializer(SerializerFacade facade) {
        this.facade = facade;
    }

    @Override
    public List<Class<?>> getMatchingClasses() {
        return Collections.emptyList();
    }

    @Override
    public SerializedObject generate(Type type, Class<?> valueType) {
        return new SerializedObject(type, valueType);
    }

    @Override
    public void populate(SerializedObject serializedObject, Object object) {
        for (Class<?> objectClass = object.getClass(); objectClass != Object.class && !this.facade.excludes(objectClass); objectClass = objectClass.getSuperclass()) {
            for (Field f : objectClass.getDeclaredFields()) {
                if (!this.isSerializable(f)) continue;
                serializedObject.addField(this.facade.serialize(f, object));
            }
        }
    }

    private boolean isSerializable(Field field) {
        return !field.isAnnotationPresent(SnapshotExcluded.class) && !field.isSynthetic() && !this.facade.excludes(field);
    }
}

