/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.serializers;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.amygdalum.testrecorder.Serializer;
import net.amygdalum.testrecorder.SerializerFacade;
import net.amygdalum.testrecorder.SerializerFactory;
import net.amygdalum.testrecorder.values.SerializedMap;

public class DefaultHashMapSerializer
implements Serializer<SerializedMap> {
    private SerializerFacade facade;

    public DefaultHashMapSerializer(SerializerFacade facade) {
        this.facade = facade;
    }

    @Override
    public List<Class<?>> getMatchingClasses() {
        return Arrays.asList(HashMap.class, LinkedHashMap.class);
    }

    @Override
    public SerializedMap generate(Type type, Class<?> valueType) {
        return new SerializedMap(type, valueType);
    }

    @Override
    public void populate(SerializedMap serializedObject, Object object) {
        for (Map.Entry entry : ((Map)object).entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            serializedObject.put(this.facade.serialize(key.getClass(), key), this.facade.serialize(value.getClass(), value));
        }
    }

    public static class Factory
    implements SerializerFactory<SerializedMap> {
        public DefaultHashMapSerializer newSerializer(SerializerFacade facade) {
            return new DefaultHashMapSerializer(facade);
        }
    }
}

