/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import net.amygdalum.testrecorder.ConfigurableSerializerFacade;
import net.amygdalum.testrecorder.ContextSnapshot;
import net.amygdalum.testrecorder.ContextSnapshotFactory;
import net.amygdalum.testrecorder.SerializerFacade;
import net.amygdalum.testrecorder.values.SerializedField;
import net.amygdalum.testrecorder.values.SerializedInput;
import net.amygdalum.testrecorder.values.SerializedOutput;

public class SnapshotProcess {
    private ExecutorService executor;
    private long timeoutInMillis;
    private ContextSnapshot snapshot;
    private SerializerFacade facade;
    private List<Field> globals;
    private List<SerializedInput> input;
    private List<SerializedOutput> output;

    public SnapshotProcess(ExecutorService executor, long timeoutInMillis, ContextSnapshotFactory factory) {
        this.executor = executor;
        this.timeoutInMillis = timeoutInMillis;
        this.snapshot = factory.createSnapshot();
        this.facade = new ConfigurableSerializerFacade(factory.profile());
        this.globals = factory.getGlobalFields();
        this.input = new ArrayList<SerializedInput>();
        this.output = new ArrayList<SerializedOutput>();
    }

    public ContextSnapshot getSnapshot() {
        return this.snapshot;
    }

    public void inputVariables(Class<?> clazz, String method, Type resultType, Object result, Type[] paramTypes, Object[] args) {
        this.input.add(new SerializedInput(clazz, method, resultType, this.facade.serialize(resultType, result), paramTypes, this.facade.serialize(paramTypes, args)));
    }

    public void inputVariables(Class<?> clazz, String method, Type[] paramTypes, Object[] args) {
        this.input.add(new SerializedInput(clazz, method, paramTypes, this.facade.serialize(paramTypes, args)));
    }

    public void outputVariables(Class<?> clazz, String method, Type[] paramTypes, Object[] args) {
        this.output.add(new SerializedOutput(clazz, method, paramTypes, this.facade.serialize(paramTypes, args)));
    }

    public void setupVariables(String signature, Object self, Object ... args) {
        this.modify(snapshot -> {
            snapshot.setSetupThis(this.facade.serialize(self.getClass(), self));
            snapshot.setSetupArgs(this.facade.serialize(snapshot.getArgumentTypes(), args));
            snapshot.setSetupGlobals((SerializedField[])this.globals.stream().map(field -> this.facade.serialize((Field)field, (Object)null)).toArray(SerializedField[]::new));
            snapshot.setSetupInput(this.input);
        });
    }

    public void expectVariables(Object self, Object result, Object ... args) {
        this.modify(snapshot -> {
            snapshot.setExpectThis(this.facade.serialize(self.getClass(), self));
            snapshot.setExpectResult(this.facade.serialize(snapshot.getResultType(), result));
            snapshot.setExpectArgs(this.facade.serialize(snapshot.getArgumentTypes(), args));
            snapshot.setExpectGlobals((SerializedField[])this.globals.stream().map(field -> this.facade.serialize((Field)field, (Object)null)).toArray(SerializedField[]::new));
            snapshot.setExpectOutput(this.output);
        });
    }

    public void expectVariables(Object self, Object ... args) {
        this.modify(snapshot -> {
            snapshot.setExpectThis(this.facade.serialize(self.getClass(), self));
            snapshot.setExpectArgs(this.facade.serialize(snapshot.getArgumentTypes(), args));
            snapshot.setExpectGlobals((SerializedField[])this.globals.stream().map(field -> this.facade.serialize((Field)field, (Object)null)).toArray(SerializedField[]::new));
            snapshot.setExpectOutput(this.output);
        });
    }

    public void throwVariables(Object self, Throwable throwable, Object[] args) {
        this.modify(snapshot -> {
            snapshot.setExpectThis(this.facade.serialize(self.getClass(), self));
            snapshot.setExpectArgs(this.facade.serialize(snapshot.getArgumentTypes(), args));
            snapshot.setExpectException(this.facade.serialize(throwable.getClass(), (Object)throwable));
            snapshot.setExpectGlobals((SerializedField[])this.globals.stream().map(field -> this.facade.serialize((Field)field, (Object)null)).toArray(SerializedField[]::new));
            snapshot.setExpectOutput(this.output);
        });
    }

    private void modify(Consumer<ContextSnapshot> task) {
        try {
            Future<?> future = this.executor.submit(() -> task.accept(this.snapshot));
            future.get(this.timeoutInMillis, TimeUnit.MILLISECONDS);
            this.facade.reset();
        }
        catch (InterruptedException | CancellationException | ExecutionException | TimeoutException e) {
            this.snapshot.invalidate();
        }
    }
}

