/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.amygdalum.testrecorder.ConfigRegistry;
import net.amygdalum.testrecorder.ContextSnapshot;
import net.amygdalum.testrecorder.ContextSnapshotFactory;
import net.amygdalum.testrecorder.Snapshot;
import net.amygdalum.testrecorder.SnapshotConfig;
import net.amygdalum.testrecorder.SnapshotConsumer;
import net.amygdalum.testrecorder.SnapshotProcess;

public class SnapshotGenerator {
    private static ThreadFactory THREADS = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    };
    private static ThreadLocal<SnapshotGenerator> currentGenerator = new ThreadLocal();
    private ThreadLocal<SnapshotGenerator> stored = new ThreadLocal();
    private Object self;
    private ExecutorService executor;
    private Map<String, ContextSnapshotFactory> methodSnapshots;
    private ThreadLocal<SnapshotProcess> current = new ThreadLocal();
    private SnapshotConsumer snapshotConsumer;
    private long timeoutInMillis;

    public SnapshotGenerator(Object self, Class<? extends SnapshotConfig> config) {
        this.snapshotConsumer = ConfigRegistry.loadConfig(config).getSnapshotConsumer();
        this.timeoutInMillis = ConfigRegistry.loadConfig(config).getTimeoutInMillis();
        this.self = self;
        this.executor = Executors.newSingleThreadExecutor(THREADS);
        this.methodSnapshots = new HashMap<String, ContextSnapshotFactory>();
    }

    public static SnapshotGenerator getCurrentGenerator() {
        return currentGenerator.get();
    }

    public SnapshotConsumer getMethodConsumer() {
        return this.snapshotConsumer;
    }

    public void register(String signature, Method method) {
        ContextSnapshotFactory factory = new ContextSnapshotFactory(method.getDeclaringClass(), method.getAnnotation(Snapshot.class), method.getGenericReturnType(), method.getName(), method.getGenericParameterTypes());
        this.methodSnapshots.put(signature, factory);
    }

    public SnapshotProcess process(ContextSnapshotFactory factory) {
        SnapshotProcess process = new SnapshotProcess(this.executor, this.timeoutInMillis, factory);
        this.current.set(process);
        return process;
    }

    public SnapshotProcess process() {
        return this.current.get();
    }

    public void setupVariables(String signature, Object ... args) {
        this.init();
        ContextSnapshotFactory factory = this.methodSnapshots.get(signature);
        SnapshotProcess process = this.process(factory);
        process.setupVariables(signature, this.self, args);
    }

    public void init() {
        this.stored.set(currentGenerator.get());
        currentGenerator.set(this);
    }

    public void inputVariables(Class<?> clazz, String method, Type resultType, Object result, Type[] paramTypes, Object ... args) {
        SnapshotProcess process = this.process();
        process.inputVariables(clazz, method, resultType, result, paramTypes, args);
    }

    public void inputVariables(Class<?> clazz, String method, Type[] paramTypes, Object ... args) {
        SnapshotProcess process = this.process();
        process.inputVariables(clazz, method, paramTypes, args);
    }

    public void outputVariables(Class<?> clazz, String method, Type[] paramTypes, Object ... args) {
        SnapshotProcess process = this.process();
        process.outputVariables(clazz, method, paramTypes, args);
    }

    public void expectVariables(Object result, Object ... args) {
        SnapshotProcess process = this.process();
        process.expectVariables(this.self, result, args);
        this.done();
        this.consume(process.getSnapshot());
    }

    public void expectVariables(Object ... args) {
        SnapshotProcess process = this.process();
        process.expectVariables(this.self, args);
        this.done();
        this.consume(process.getSnapshot());
    }

    public void throwVariables(Throwable throwable, Object ... args) {
        SnapshotProcess process = this.process();
        process.throwVariables(this.self, throwable, args);
        this.done();
        this.consume(process.getSnapshot());
    }

    public void done() {
        currentGenerator.set(this.stored.get());
        this.stored.remove();
    }

    private void consume(ContextSnapshot snapshot) {
        if (snapshot.isValid() && this.snapshotConsumer != null) {
            this.snapshotConsumer.accept(snapshot);
        }
    }
}

