/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.amygdalum.testrecorder.SerializationException;
import net.amygdalum.testrecorder.SerializationProfile;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.Serializer;
import net.amygdalum.testrecorder.SerializerFacade;
import net.amygdalum.testrecorder.SerializerFactory;
import net.amygdalum.testrecorder.serializers.ArraySerializer;
import net.amygdalum.testrecorder.serializers.GenericSerializer;
import net.amygdalum.testrecorder.values.SerializedArray;
import net.amygdalum.testrecorder.values.SerializedField;
import net.amygdalum.testrecorder.values.SerializedLiteral;
import net.amygdalum.testrecorder.values.SerializedNull;

public class ConfigurableSerializerFacade
implements SerializerFacade {
    private Map<Class<?>, Serializer<?>> serializers;
    private Map<Object, SerializedValue> serialized;
    private List<Predicate<Class<?>>> classExclusions;
    private List<Predicate<Field>> fieldExclusions;

    public ConfigurableSerializerFacade(SerializationProfile profile) {
        this.serializers = ConfigurableSerializerFacade.setupSerializers(this, profile.getSerializerFactories());
        this.serialized = new IdentityHashMap<Object, SerializedValue>();
        this.classExclusions = profile.getClassExclusions();
        this.fieldExclusions = profile.getFieldExclusions();
    }

    private static Map<Class<?>, Serializer<?>> setupSerializers(SerializerFacade facade, List<SerializerFactory<?>> serializerFactories) {
        IdentityHashMap serializers = new IdentityHashMap();
        serializerFactories.stream().map(factory -> factory.newSerializer(facade)).forEach(serializer -> {
            for (Class<?> clazz : serializer.getMatchingClasses()) {
                serializers.put(clazz, (Serializer<?>)serializer);
            }
        });
        return serializers;
    }

    @Override
    public void reset() {
        this.serialized.clear();
    }

    @Override
    public SerializedValue serialize(Type type, Object object) {
        if (object == null) {
            return SerializedNull.nullInstance(type);
        }
        if (SerializedLiteral.isLiteral(object.getClass())) {
            return SerializedLiteral.literal(object.getClass(), object);
        }
        SerializedValue serializedObject = this.serialized.get(object);
        if (serializedObject == null) {
            Serializer<?> serializer = this.fetchSerializer(object.getClass());
            serializedObject = serializer.generate(type, object.getClass());
            this.serialized.put(object, serializedObject);
            serializer.populate(serializedObject, object);
        }
        return serializedObject;
    }

    private Serializer<?> fetchSerializer(Class<?> clazz) {
        Serializer<SerializedArray> serializer = this.serializers.get(clazz);
        if (serializer != null) {
            return serializer;
        }
        serializer = clazz.isArray() ? new ArraySerializer(this) : new GenericSerializer(this);
        return serializer;
    }

    @Override
    public SerializedValue[] serialize(Type[] clazzes, Object[] objects) {
        return (SerializedValue[])IntStream.range(0, clazzes.length).mapToObj(i -> this.serialize(clazzes[i], objects[i])).toArray(SerializedValue[]::new);
    }

    @Override
    public SerializedField serialize(Field f, Object obj) {
        try {
            boolean access = f.isAccessible();
            if (!access) {
                f.setAccessible(true);
            }
            SerializedField field = new SerializedField(f.getDeclaringClass(), f.getName(), f.getType(), this.serialize(f.getType(), f.get(obj)));
            if (!access) {
                f.setAccessible(false);
            }
            return field;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            System.out.println(f.getName());
            throw new SerializationException(e);
        }
    }

    @Override
    public boolean excludes(Field field) {
        boolean excluded = this.fieldExclusions.stream().anyMatch(exclusion -> exclusion.test(field));
        if (!excluded) {
            Class<?> type = field.getType();
            excluded = this.classExclusions.stream().anyMatch(exclusion -> exclusion.test(type));
        }
        return excluded;
    }

    @Override
    public boolean excludes(Class<?> clazz) {
        return this.classExclusions.stream().anyMatch(exclusion -> exclusion.test(clazz));
    }
}

