/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.amygdalum.testrecorder.DefaultConfig;
import net.amygdalum.testrecorder.SnapshotConfig;
import net.amygdalum.testrecorder.SnapshotConsumer;

public class ConfigRegistry {
    private static final ConfigRegistry INSTANCE = new ConfigRegistry();
    private static final DefaultConfig DEFAULT = new DefaultConfig();
    private Map<Class<? extends SnapshotConfig>, SnapshotConfig> configs = new IdentityHashMap<Class<? extends SnapshotConfig>, SnapshotConfig>();

    public static SnapshotConfig loadConfig(Class<? extends SnapshotConfig> config) {
        return INSTANCE.fetchConfig(config);
    }

    public SnapshotConfig fetchConfig(Class<? extends SnapshotConfig> key) {
        return this.configs.computeIfAbsent(key, k -> this.createConfig((Class<? extends SnapshotConfig>)k));
    }

    public SnapshotConfig createConfig(Class<? extends SnapshotConfig> config) {
        try {
            return new ImmutableSnapshotConfig(config.newInstance());
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            return DEFAULT;
        }
    }

    private static class ImmutableSnapshotConfig
    implements SnapshotConfig {
        private SnapshotConsumer snapshotConsumer;
        private long timeoutInMillis;
        private List<String> packages;
        private Class<? extends Runnable> initializer;

        public ImmutableSnapshotConfig(SnapshotConfig config) {
            this.snapshotConsumer = config.getSnapshotConsumer();
            this.timeoutInMillis = config.getTimeoutInMillis();
            this.packages = config.getPackages();
            this.initializer = config.getInitializer();
        }

        @Override
        public SnapshotConsumer getSnapshotConsumer() {
            return this.snapshotConsumer;
        }

        @Override
        public long getTimeoutInMillis() {
            return this.timeoutInMillis;
        }

        @Override
        public List<String> getPackages() {
            return this.packages;
        }

        @Override
        public Class<? extends Runnable> getInitializer() {
            return this.initializer;
        }
    }
}

