/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.ConfigurableSerializerFacade;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.SerializedValueVisitor;
import net.amygdalum.testrecorder.SerializerFacade;
import net.amygdalum.testrecorder.profile.DefaultSerializationProfile;
import net.amygdalum.testrecorder.visitors.Computation;
import net.amygdalum.testrecorder.visitors.LocalVariableNameGenerator;
import net.amygdalum.testrecorder.visitors.ObjectToSetupCode;
import net.amygdalum.testrecorder.visitors.SerializedValueVisitorFactory;
import net.amygdalum.testrecorder.visitors.Templates;
import net.amygdalum.testrecorder.visitors.TypeManager;

public class CodeSerializer {
    private SerializerFacade facade;
    private TypeManager types = new TypeManager();
    private SerializedValueVisitorFactory serializers;

    public CodeSerializer() {
        this(new ConfigurableSerializerFacade(new DefaultSerializationProfile()), new ObjectToSetupCode.Factory());
    }

    public CodeSerializer(SerializedValueVisitorFactory serializers) {
        this(new ConfigurableSerializerFacade(new DefaultSerializationProfile()), serializers);
    }

    public CodeSerializer(SerializerFacade facade, SerializedValueVisitorFactory serializers) {
        this.facade = facade;
        this.serializers = serializers;
    }

    public String serialize(Object value) {
        return this.serialize(this.serializers.resultType(value.getClass()), value);
    }

    public String serialize(Type type, Object value) {
        SerializedValue serializedValue = this.facade.serialize(type, value);
        return new Generator(serializedValue).generateCode();
    }

    private class Generator {
        private LocalVariableNameGenerator locals;
        private SerializedValue value;
        private String type;
        private List<String> statements;

        public Generator(SerializedValue value) {
            this.value = value;
            this.type = CodeSerializer.this.types.getSimpleName(value.getType());
            this.locals = new LocalVariableNameGenerator();
            this.statements = new ArrayList<String>();
        }

        public String generateCode() {
            SerializedValueVisitor<Computation> serializer = CodeSerializer.this.serializers.create(this.locals, CodeSerializer.this.types);
            Computation serialized = this.value.accept(serializer);
            this.statements.addAll(serialized.getStatements());
            if (!serialized.isStored()) {
                String name = this.locals.fetchName(this.value.getClass());
                this.statements.add(Templates.assignLocalVariableStatement(this.type, name, serialized.getValue()));
            }
            return this.statements.stream().collect(Collectors.joining("\n"));
        }
    }
}

