/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.visitors;

import com.almondtools.conmatch.datatypes.MapMatcher;
import com.almondtools.conmatch.datatypes.PrimitiveArrayMatcher;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.SerializedCollectionVisitor;
import net.amygdalum.testrecorder.SerializedImmutableVisitor;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.SerializedValueVisitor;
import net.amygdalum.testrecorder.util.GenericMatcher;
import net.amygdalum.testrecorder.values.SerializedArray;
import net.amygdalum.testrecorder.values.SerializedBigDecimal;
import net.amygdalum.testrecorder.values.SerializedBigInteger;
import net.amygdalum.testrecorder.values.SerializedField;
import net.amygdalum.testrecorder.values.SerializedList;
import net.amygdalum.testrecorder.values.SerializedLiteral;
import net.amygdalum.testrecorder.values.SerializedMap;
import net.amygdalum.testrecorder.values.SerializedNull;
import net.amygdalum.testrecorder.values.SerializedObject;
import net.amygdalum.testrecorder.values.SerializedSet;
import net.amygdalum.testrecorder.visitors.Computation;
import net.amygdalum.testrecorder.visitors.LocalVariableNameGenerator;
import net.amygdalum.testrecorder.visitors.SerializedValueVisitorFactory;
import net.amygdalum.testrecorder.visitors.Templates;
import net.amygdalum.testrecorder.visitors.TypeManager;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class ObjectToMatcherCode
implements SerializedValueVisitor<Computation>,
SerializedCollectionVisitor<Computation>,
SerializedImmutableVisitor<Computation> {
    private Set<SerializedValue> computed;
    private TypeManager types;

    public ObjectToMatcherCode() {
        this(new LocalVariableNameGenerator(), new TypeManager());
    }

    public ObjectToMatcherCode(LocalVariableNameGenerator locals, TypeManager types) {
        this.types = types;
        this.computed = new HashSet<SerializedValue>();
    }

    public TypeManager getTypes() {
        return this.types;
    }

    @Override
    public Computation visitField(SerializedField field) {
        SerializedValue fieldValue = field.getValue();
        if (this.isSimpleValue(fieldValue)) {
            this.types.registerImport(TypeManager.getBase(field.getType()));
            Computation value = this.getSimpleValue(fieldValue);
            String assignField = Templates.assignLocalVariableStatement(this.types.getRawName(field.getType()), field.getName(), value.getValue());
            return new Computation(assignField, value.getStatements());
        }
        this.types.registerImport(Matcher.class);
        Computation value = fieldValue.accept(this);
        String genericType = this.types.getSimpleName(value.getType());
        String assignField = Templates.assignLocalVariableStatement(genericType, field.getName(), value.getValue());
        return new Computation(assignField, value.getStatements());
    }

    @Override
    public Computation visitObject(SerializedObject value) {
        if (!this.computed.add(value)) {
            this.types.staticImport(GenericMatcher.class, "recursive");
            Type resultType = value.getType().equals(value.getValueType()) ? TypeManager.parameterized(Matcher.class, null, new Type[]{value.getType()}) : TypeManager.parameterized(Matcher.class, null, new Type[]{TypeManager.wildcard()});
            return new Computation(Templates.recursiveMatcher(this.types.getRawTypeName(value.getValueType())), resultType);
        }
        this.types.registerTypes(new Type[]{value.getType(), value.getValueType(), GenericMatcher.class});
        List fields = value.getFields().stream().sorted().map(field -> field.accept(this)).collect(Collectors.toList());
        List<String> fieldComputations = fields.stream().flatMap(field -> field.getStatements().stream()).collect(Collectors.toList());
        List<String> fieldAssignments = fields.stream().map(field -> field.getValue()).collect(Collectors.toList());
        Type resultType = TypeManager.parameterized(Matcher.class, null, new Type[]{value.getType()});
        String matcherExpression = this.createMatcherExpression(value, fieldAssignments);
        return new Computation(matcherExpression, resultType, fieldComputations);
    }

    public String createMatcherExpression(SerializedObject value, List<String> fieldAssignments) {
        Class<?> valueType;
        Type type = value.getType();
        if (TypeManager.getBase(type) == Matcher.class) {
            type = TypeManager.getArgument(type, 0);
        }
        if (type.equals(valueType = value.getValueType())) {
            String matcherRawType = this.types.getRawTypeName(valueType);
            return Templates.genericObjectMatcher(matcherRawType, fieldAssignments);
        }
        String matcherRawType = this.types.getRawTypeName(valueType);
        String matcherToType = this.types.getRawTypeName(type);
        return Templates.genericObjectMatcher(matcherRawType, matcherToType, fieldAssignments);
    }

    @Override
    public Computation visitList(SerializedList value) {
        if (!this.computed.add(value)) {
            this.types.staticImport(GenericMatcher.class, "recursive");
            return new Computation(Templates.recursiveMatcher(this.types.getRawName(value.getValueType())), TypeManager.parameterized(Matcher.class, null, new Type[]{TypeManager.wildcard()}));
        }
        if (value.isEmpty()) {
            this.types.staticImport(Matchers.class, "empty");
            return new Computation(Templates.emptyMatcher(), TypeManager.parameterized(Matcher.class, null, new Type[]{TypeManager.wildcard()}), Collections.emptyList());
        }
        this.types.staticImport(Matchers.class, "contains");
        List elements = value.stream().map(element -> this.getSimpleValue((SerializedValue)element)).collect(Collectors.toList());
        List<String> elementComputations = elements.stream().flatMap(element -> element.getStatements().stream()).collect(Collectors.toList());
        String[] elementValues = (String[])elements.stream().map(element -> element.getValue()).toArray(String[]::new);
        String containsMatcher = Templates.containsMatcher(elementValues);
        return new Computation(containsMatcher, TypeManager.parameterized(Matcher.class, null, new Type[]{TypeManager.wildcard()}), elementComputations);
    }

    @Override
    public Computation visitSet(SerializedSet value) {
        if (!this.computed.add(value)) {
            this.types.staticImport(GenericMatcher.class, "recursive");
            return new Computation(Templates.recursiveMatcher(this.types.getRawName(value.getValueType())), TypeManager.parameterized(Matcher.class, null, new Type[]{TypeManager.wildcard()}));
        }
        if (value.isEmpty()) {
            this.types.staticImport(Matchers.class, "empty");
            String emptyMatcher = Templates.emptyMatcher();
            return new Computation(emptyMatcher, TypeManager.parameterized(Matcher.class, null, new Type[]{TypeManager.wildcard()}), Collections.emptyList());
        }
        this.types.staticImport(Matchers.class, "containsInAnyOrder");
        List elements = value.stream().map(element -> this.getSimpleValue((SerializedValue)element)).collect(Collectors.toList());
        List<String> elementComputations = elements.stream().flatMap(element -> element.getStatements().stream()).collect(Collectors.toList());
        String[] elementValues = (String[])elements.stream().map(element -> element.getValue()).toArray(String[]::new);
        String containsInAnyOrderMatcher = Templates.containsInAnyOrderMatcher(elementValues);
        return new Computation(containsInAnyOrderMatcher, TypeManager.parameterized(Matcher.class, null, new Type[]{TypeManager.wildcard()}), elementComputations);
    }

    @Override
    public Computation visitMap(SerializedMap value) {
        if (!this.computed.add(value)) {
            this.types.staticImport(GenericMatcher.class, "recursive");
            return new Computation(Templates.recursiveMatcher(this.types.getRawName(value.getValueType())), TypeManager.parameterized(Matcher.class, null, new Type[]{TypeManager.wildcard()}));
        }
        String keyType = this.types.getSimpleName(value.getMapKeyType());
        String valueType = this.types.getSimpleName(value.getMapValueType());
        if (value.isEmpty()) {
            this.types.staticImport(MapMatcher.class, "noEntries");
            String noEntriesMatcher = Templates.noEntriesMatcher(keyType, valueType);
            return new Computation(noEntriesMatcher, TypeManager.parameterized(Matcher.class, null, new Type[]{TypeManager.wildcard()}), Collections.emptyList());
        }
        this.types.staticImport(MapMatcher.class, "containsEntries");
        Map<Computation, Computation> elements = value.entrySet().stream().collect(Collectors.toMap(entry -> this.getSimpleValue((SerializedValue)entry.getKey()), entry -> this.getSimpleValue((SerializedValue)entry.getValue())));
        List<String> entryComputations = elements.entrySet().stream().flatMap(entry -> Stream.concat(((Computation)entry.getKey()).getStatements().stream(), ((Computation)entry.getValue()).getStatements().stream())).collect(Collectors.toList());
        Set<Map.Entry<String, String>> entryValues = elements.entrySet().stream().collect(Collectors.toMap(entry -> ((Computation)entry.getKey()).getValue(), entry -> ((Computation)entry.getValue()).getValue())).entrySet();
        String containsEntriesMatcher = Templates.containsEntriesMatcher(keyType, valueType, entryValues);
        return new Computation(containsEntriesMatcher, TypeManager.parameterized(Matcher.class, null, new Type[]{TypeManager.wildcard()}), entryComputations);
    }

    @Override
    public Computation visitArray(SerializedArray value) {
        if (!this.computed.add(value)) {
            this.types.staticImport(GenericMatcher.class, "recursive");
            return new Computation(Templates.recursiveMatcher(this.types.getRawName(value.getValueType())), TypeManager.parameterized(Matcher.class, null, new Type[]{TypeManager.wildcard()}));
        }
        if (TypeManager.isPrimitive(value.getComponentType())) {
            String name = value.getComponentType().getTypeName();
            this.types.staticImport(PrimitiveArrayMatcher.class, name + "ArrayContaining");
            List elements = Stream.of(value.getArray()).map(element -> this.getSimpleValue((SerializedValue)element)).collect(Collectors.toList());
            List<String> elementComputations = elements.stream().flatMap(element -> element.getStatements().stream()).collect(Collectors.toList());
            String[] elementValues = (String[])elements.stream().map(element -> element.getValue()).toArray(String[]::new);
            String primitiveArrayContainingMatcher = Templates.primitiveArrayContainingMatcher(name, elementValues);
            return new Computation(primitiveArrayContainingMatcher, TypeManager.parameterized(Matcher.class, null, new Type[]{TypeManager.wildcard()}), elementComputations);
        }
        this.types.staticImport(Matchers.class, "arrayContaining");
        List elements = Stream.of(value.getArray()).map(element -> this.getSimpleValue((SerializedValue)element)).collect(Collectors.toList());
        List<String> elementComputations = elements.stream().flatMap(element -> element.getStatements().stream()).collect(Collectors.toList());
        String[] elementValues = (String[])elements.stream().map(element -> element.getValue()).toArray(String[]::new);
        String arrayContainingMatcher = Templates.arrayContainingMatcher(elementValues);
        return new Computation(arrayContainingMatcher, TypeManager.parameterized(Matcher.class, null, new Type[]{TypeManager.wildcard()}), elementComputations);
    }

    @Override
    public Computation visitLiteral(SerializedLiteral value) {
        this.types.staticImport(Matchers.class, "equalTo");
        String valueExpression = Templates.asLiteral(value.getValue());
        String equalToMatcher = Templates.equalToMatcher(valueExpression);
        return new Computation(equalToMatcher, TypeManager.parameterized(Matcher.class, null, new Type[]{value.getValueType()}), Collections.emptyList());
    }

    @Override
    public Computation visitNull(SerializedNull value) {
        this.types.registerImport(value.getValueType());
        this.types.staticImport(Matchers.class, "nullValue");
        String nullMatcher = Templates.nullMatcher(this.types.getRawName(value.getValueType()));
        return new Computation(nullMatcher, TypeManager.parameterized(Matcher.class, null, new Type[]{value.getValueType()}), Collections.emptyList());
    }

    @Override
    public Computation visitBigDecimal(SerializedBigDecimal value) {
        this.types.registerImport(BigDecimal.class);
        this.types.staticImport(Matchers.class, "equalTo");
        String literal = Templates.asLiteral(((BigDecimal)value.getValue()).toPlainString());
        String bigDecimalLiteral = Templates.newObject("BigDecimal", literal);
        String equalToMatcher = Templates.equalToMatcher(bigDecimalLiteral);
        return new Computation(equalToMatcher, TypeManager.parameterized(Matcher.class, null, new Type[]{value.getValueType()}), Collections.emptyList());
    }

    @Override
    public Computation visitBigInteger(SerializedBigInteger value) {
        this.types.registerImport(BigInteger.class);
        this.types.staticImport(Matchers.class, "equalTo");
        String literal = Templates.asLiteral(((BigInteger)value.getValue()).toString());
        String bigIntegerLiteral = Templates.newObject("BigInteger", literal);
        String equalToMatcher = Templates.equalToMatcher(bigIntegerLiteral);
        return new Computation(equalToMatcher, TypeManager.parameterized(Matcher.class, null, new Type[]{value.getValueType()}), Collections.emptyList());
    }

    @Override
    public Computation visitUnknown(SerializedValue value) {
        return Computation.NULL;
    }

    private boolean isSimpleValue(SerializedValue element) {
        return element instanceof SerializedNull || element instanceof SerializedLiteral;
    }

    private Computation getSimpleValue(SerializedValue element) {
        if (element instanceof SerializedNull) {
            return new Computation("null");
        }
        if (element instanceof SerializedLiteral) {
            return new Computation(Templates.asLiteral(((SerializedLiteral)element).getValue()));
        }
        return element.accept(this);
    }

    public static class Factory
    implements SerializedValueVisitorFactory {
        @Override
        public SerializedValueVisitor<Computation> create(LocalVariableNameGenerator locals, TypeManager types) {
            return new ObjectToMatcherCode(locals, types);
        }

        @Override
        public Type resultType(Type type) {
            return TypeManager.parameterized(Matcher.class, null, new Type[]{type});
        }
    }
}

