/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.visitors;

import java.util.function.Function;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.SerializedValueVisitor;
import net.amygdalum.testrecorder.values.SerializedArray;
import net.amygdalum.testrecorder.values.SerializedField;
import net.amygdalum.testrecorder.values.SerializedLiteral;
import net.amygdalum.testrecorder.values.SerializedNull;
import net.amygdalum.testrecorder.values.SerializedObject;

public class MappedSerializedValueVisitor<T, S>
implements SerializedValueVisitor<T> {
    private SerializedValueVisitor<S> visitor;
    private Function<S, T> mapping;

    public MappedSerializedValueVisitor(SerializedValueVisitor<S> visitor, Function<S, T> mapping) {
        this.visitor = visitor;
        this.mapping = mapping;
    }

    @Override
    public T visitField(SerializedField field) {
        return this.mapping.apply(field.accept(this.visitor));
    }

    @Override
    public T visitObject(SerializedObject value) {
        return this.mapping.apply(value.accept(this.visitor));
    }

    @Override
    public T visitArray(SerializedArray value) {
        return this.mapping.apply(value.accept(this.visitor));
    }

    @Override
    public T visitLiteral(SerializedLiteral value) {
        return this.mapping.apply(value.accept(this.visitor));
    }

    @Override
    public T visitNull(SerializedNull value) {
        return this.mapping.apply(value.accept(this.visitor));
    }

    @Override
    public T visitUnknown(SerializedValue value) {
        return this.mapping.apply(value.accept(this.visitor));
    }
}

