/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.visitors;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.amygdalum.testrecorder.DeserializationException;
import net.amygdalum.testrecorder.SerializedCollectionVisitor;
import net.amygdalum.testrecorder.SerializedImmutableVisitor;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.SerializedValueVisitor;
import net.amygdalum.testrecorder.util.GenericObject;
import net.amygdalum.testrecorder.util.GenericObjectException;
import net.amygdalum.testrecorder.values.SerializedArray;
import net.amygdalum.testrecorder.values.SerializedBigDecimal;
import net.amygdalum.testrecorder.values.SerializedBigInteger;
import net.amygdalum.testrecorder.values.SerializedField;
import net.amygdalum.testrecorder.values.SerializedList;
import net.amygdalum.testrecorder.values.SerializedLiteral;
import net.amygdalum.testrecorder.values.SerializedMap;
import net.amygdalum.testrecorder.values.SerializedNull;
import net.amygdalum.testrecorder.values.SerializedObject;
import net.amygdalum.testrecorder.values.SerializedSet;

public class Deserializer
implements SerializedValueVisitor<Object>,
SerializedCollectionVisitor<Object>,
SerializedImmutableVisitor<Object> {
    private Map<SerializedValue, Object> deserialized = new IdentityHashMap<SerializedValue, Object>();

    private <T> T fetch(SerializedValue key, Supplier<T> supplier, Consumer<T> init) {
        Object value = this.deserialized.get(key);
        if (value == null) {
            value = supplier.get();
            this.deserialized.put(key, value);
            init.accept(value);
        }
        return (T)value;
    }

    @Override
    public Object visitField(SerializedField field) {
        throw new DeserializationException(field.toString());
    }

    @Override
    public Object visitObject(SerializedObject value) {
        try {
            Object object = this.fetch(value, () -> GenericObject.newInstance(value.getValueType()), base -> {
                for (SerializedField field : value.getFields()) {
                    GenericObject.setField(base, field.getName(), field.getValue().accept(this));
                }
            });
            return object;
        }
        catch (GenericObjectException e) {
            throw new DeserializationException(value.toString());
        }
    }

    @Override
    public Object visitBigDecimal(SerializedBigDecimal value) {
        return this.fetch(value, () -> (BigDecimal)value.getValue(), this.noInit());
    }

    @Override
    public Object visitBigInteger(SerializedBigInteger value) {
        return this.fetch(value, () -> (BigInteger)value.getValue(), this.noInit());
    }

    @Override
    public Object visitList(SerializedList value) {
        List list = this.fetch(value, ArrayList::new, base -> {
            for (SerializedValue element : value) {
                base.add(element.accept(this));
            }
        });
        return list;
    }

    @Override
    public Object visitMap(SerializedMap value) {
        Map map = this.fetch(value, LinkedHashMap::new, base -> {
            for (Map.Entry<SerializedValue, SerializedValue> entry : value.entrySet()) {
                Object k = entry.getKey().accept(this);
                Object v = entry.getValue().accept(this);
                base.put(k, v);
            }
        });
        return map;
    }

    @Override
    public Object visitSet(SerializedSet value) {
        Set set = this.fetch(value, LinkedHashSet::new, base -> {
            for (SerializedValue element : value) {
                base.add(element.accept(this));
            }
        });
        return set;
    }

    @Override
    public Object visitArray(SerializedArray value) {
        Class<?> componentType = value.getRawType();
        SerializedValue[] rawArray = value.getArray();
        Object[] array = this.fetch(value, () -> (Object[])Array.newInstance(componentType, rawArray.length), base -> {
            for (int i = 0; i < rawArray.length; ++i) {
                base[i] = rawArray[i].accept(this);
            }
        });
        return array;
    }

    @Override
    public Object visitLiteral(SerializedLiteral value) {
        return this.fetch(value, () -> value.getValue(), this.noInit());
    }

    @Override
    public Object visitNull(SerializedNull value) {
        return null;
    }

    @Override
    public Object visitUnknown(SerializedValue value) {
        throw new DeserializationException(value.toString());
    }

    private <T> Consumer<T> noInit() {
        return base -> {};
    }
}

