/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.amygdalum.testrecorder.SerializedCollectionVisitor;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.SerializedValueVisitor;
import net.amygdalum.testrecorder.visitors.SerializedValuePrinter;
import net.amygdalum.testrecorder.visitors.TypeManager;

public class SerializedSet
implements SerializedValue,
Set<SerializedValue> {
    private Type type;
    private Class<?> valueType;
    private Set<SerializedValue> set;

    public SerializedSet(Type type, Class<?> valueType) {
        this.type = type;
        this.valueType = valueType;
        this.set = new LinkedHashSet<SerializedValue>();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Class<?> getValueType() {
        return TypeManager.getBase(this.valueType);
    }

    public Type getComponentType() {
        if (this.type instanceof ParameterizedType) {
            return ((ParameterizedType)this.type).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    @Override
    public <T> T accept(SerializedValueVisitor<T> visitor) {
        return (T)visitor.as(SerializedCollectionVisitor.extend(visitor)).map(v -> v.visitSet(this)).orElseGet(() -> visitor.visitUnknown(this));
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public Iterator<SerializedValue> iterator() {
        return this.set.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.set.toArray(a);
    }

    @Override
    public boolean add(SerializedValue e) {
        return this.set.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends SerializedValue> c) {
        return this.set.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.set.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.set.removeAll(c);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    public String toString() {
        return this.accept(new SerializedValuePrinter());
    }
}

