/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.SerializedValueVisitor;
import net.amygdalum.testrecorder.values.SerializedField;
import net.amygdalum.testrecorder.visitors.SerializedValuePrinter;
import net.amygdalum.testrecorder.visitors.TypeManager;

public class SerializedObject
implements SerializedValue {
    private Type type;
    private Class<?> valueType;
    private List<SerializedField> fields;

    public SerializedObject(Type type, Class<?> valueType) {
        this.type = type;
        this.valueType = valueType;
        this.fields = new ArrayList<SerializedField>();
    }

    public SerializedObject withFields(SerializedField ... fields) {
        this.fields.addAll(Arrays.asList(fields));
        return this;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Class<?> getValueType() {
        return TypeManager.getBase(this.valueType);
    }

    public List<SerializedField> getFields() {
        return this.fields;
    }

    public void addField(SerializedField field) {
        this.fields.add(field);
    }

    @Override
    public <T> T accept(SerializedValueVisitor<T> visitor) {
        return visitor.visitObject(this);
    }

    public String toString() {
        return this.accept(new SerializedValuePrinter());
    }
}

