/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.amygdalum.testrecorder.SerializedCollectionVisitor;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.SerializedValueVisitor;
import net.amygdalum.testrecorder.visitors.SerializedValuePrinter;
import net.amygdalum.testrecorder.visitors.TypeManager;

public class SerializedMap
implements SerializedValue,
Map<SerializedValue, SerializedValue> {
    private Type type;
    private Class<?> valueType;
    private Map<SerializedValue, SerializedValue> map;

    public SerializedMap(Type type, Class<?> valueType) {
        this.type = type;
        this.valueType = valueType;
        this.map = new LinkedHashMap<SerializedValue, SerializedValue>();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Class<?> getValueType() {
        return TypeManager.getBase(this.valueType);
    }

    public Type getMapKeyType() {
        if (this.type instanceof ParameterizedType) {
            return ((ParameterizedType)this.type).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    public Type getMapValueType() {
        if (this.type instanceof ParameterizedType) {
            return ((ParameterizedType)this.type).getActualTypeArguments()[1];
        }
        return Object.class;
    }

    @Override
    public <T> T accept(SerializedValueVisitor<T> visitor) {
        return (T)visitor.as(SerializedCollectionVisitor.extend(visitor)).map(v -> v.visitMap(this)).orElseGet(() -> visitor.visitUnknown(this));
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public SerializedValue get(Object key) {
        return this.map.get(key);
    }

    @Override
    public SerializedValue put(SerializedValue key, SerializedValue value) {
        return this.map.put(key, value);
    }

    @Override
    public SerializedValue remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends SerializedValue, ? extends SerializedValue> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<SerializedValue> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<SerializedValue> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<SerializedValue, SerializedValue>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        return this.accept(new SerializedValuePrinter());
    }
}

