/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.values;

import java.lang.reflect.Type;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.SerializedValueVisitor;
import net.amygdalum.testrecorder.visitors.SerializedValuePrinter;

public class SerializedField
implements Comparable<SerializedField> {
    private String name;
    private Type type;
    private SerializedValue value;
    private Class<?> clazz;

    public SerializedField(Class<?> clazz, String name, Type type, SerializedValue value) {
        this.clazz = clazz;
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public SerializedValue getValue() {
        return this.value;
    }

    public <T> T accept(SerializedValueVisitor<T> visitor) {
        return visitor.visitField(this);
    }

    public String toString() {
        return this.accept(new SerializedValuePrinter());
    }

    @Override
    public int compareTo(SerializedField o) {
        return this.name.compareTo(o.name);
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + this.type.getTypeName().hashCode() * 13 + this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializedField that = (SerializedField)obj;
        return this.clazz.equals(that.clazz) && this.name.equals(that.name) && this.type == that.type && this.value.equals(that.value);
    }
}

